# coding: utf-8

"""
    Sematext Cloud API

    API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.  # noqa: E501

    OpenAPI spec version: v3

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class UserRole(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'role': 'str',
        'role_status': 'str',
        'user_email': 'str'
    }

    attribute_map = {
        'role': 'role',
        'role_status': 'roleStatus',
        'user_email': 'userEmail'
    }

    def __init__(self, role=None, role_status=None, user_email=None):  # noqa: E501
        """UserRole - a model defined in Swagger"""  # noqa: E501

        self._role = None
        self._role_status = None
        self._user_email = None
        self.discriminator = None

        if role is not None:
            self.role = role
        if role_status is not None:
            self.role_status = role_status
        if user_email is not None:
            self.user_email = user_email

    @property
    def role(self):
        """Gets the role of this UserRole.  # noqa: E501


        :return: The role of this UserRole.  # noqa: E501
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this UserRole.


        :param role: The role of this UserRole.  # noqa: E501
        :type: str
        """
        allowed_values = ["SUPER_USER", "OWNER", "ADMIN", "USER", "DEMO", "ANONYMOUS"]  # noqa: E501
        if role not in allowed_values:
            raise ValueError(
                "Invalid value for `role` ({0}), must be one of {1}"  # noqa: E501
                .format(role, allowed_values)
            )

        self._role = role

    @property
    def role_status(self):
        """Gets the role_status of this UserRole.  # noqa: E501


        :return: The role_status of this UserRole.  # noqa: E501
        :rtype: str
        """
        return self._role_status

    @role_status.setter
    def role_status(self, role_status):
        """Sets the role_status of this UserRole.


        :param role_status: The role_status of this UserRole.  # noqa: E501
        :type: str
        """
        allowed_values = ["INACTIVE", "ACTIVE"]  # noqa: E501
        if role_status not in allowed_values:
            raise ValueError(
                "Invalid value for `role_status` ({0}), must be one of {1}"  # noqa: E501
                .format(role_status, allowed_values)
            )

        self._role_status = role_status

    @property
    def user_email(self):
        """Gets the user_email of this UserRole.  # noqa: E501


        :return: The user_email of this UserRole.  # noqa: E501
        :rtype: str
        """
        return self._user_email

    @user_email.setter
    def user_email(self, user_email):
        """Sets the user_email of this UserRole.


        :param user_email: The user_email of this UserRole.  # noqa: E501
        :type: str
        """

        self._user_email = user_email

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UserRole, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserRole):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
