"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckParameterFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
class CheckParameterFunction extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        super(scope, id, {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'check-parameter')),
        });
        if (props.crossAccountRole) {
            this.addToRolePolicy(new aws_iam_1.PolicyStatement({
                resources: [props.crossAccountRole.roleArn],
                actions: ['sts:AssumeRole'],
            }));
        }
        else {
            const parameterArn = core_1.Stack.of(scope).formatArn({
                service: 'ssm',
                resource: 'parameter',
                sep: props.parameterName.startsWith('/') ? '' : '/',
                resourceName: props.parameterName,
            });
            this.addToRolePolicy(new aws_iam_1.PolicyStatement({
                resources: [parameterArn],
                actions: ['ssm:GetParameter'],
            }));
        }
    }
}
exports.CheckParameterFunction = CheckParameterFunction;
_a = JSII_RTTI_SYMBOL_1;
CheckParameterFunction[_a] = { fqn: "@cloudcomponents/cdk-codepipeline-check-parameter-action.CheckParameterFunction", version: "1.24.0" };
//# sourceMappingURL=data:application/json;base64,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