"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcEndpointService = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
const ec2_generated_1 = require("./ec2.generated");
/**
 * A VPC endpoint service
 * @resource AWS::EC2::VPCEndpointService
 *
 */
class VpcEndpointService extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ec2_VpcEndpointServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, VpcEndpointService);
            }
            throw error;
        }
        if (props.vpcEndpointServiceLoadBalancers === undefined || props.vpcEndpointServiceLoadBalancers.length === 0) {
            throw new Error('VPC Endpoint Service must have at least one load balancer specified.');
        }
        this.vpcEndpointServiceLoadBalancers = props.vpcEndpointServiceLoadBalancers;
        this.acceptanceRequired = props.acceptanceRequired ?? true;
        if (props.allowedPrincipals && props.whitelistedPrincipals) {
            throw new Error('`whitelistedPrincipals` is deprecated; please use `allowedPrincipals` instead');
        }
        this.allowedPrincipals = props.allowedPrincipals ?? props.whitelistedPrincipals ?? [];
        this.whitelistedPrincipals = this.allowedPrincipals;
        this.endpointService = new ec2_generated_1.CfnVPCEndpointService(this, id, {
            networkLoadBalancerArns: this.vpcEndpointServiceLoadBalancers.map(lb => lb.loadBalancerArn),
            acceptanceRequired: this.acceptanceRequired,
        });
        this.vpcEndpointServiceId = this.endpointService.ref;
        const { region } = core_1.Stack.of(this);
        const serviceNamePrefix = !core_1.Token.isUnresolved(region) ?
            (region_info_1.RegionInfo.get(region).vpcEndpointServiceNamePrefix ?? region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX) :
            region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX;
        this.vpcEndpointServiceName = core_1.Fn.join('.', [serviceNamePrefix, core_1.Aws.REGION, this.vpcEndpointServiceId]);
        if (this.allowedPrincipals.length > 0) {
            new ec2_generated_1.CfnVPCEndpointServicePermissions(this, 'Permissions', {
                serviceId: this.endpointService.ref,
                allowedPrincipals: this.allowedPrincipals.map(x => x.arn),
            });
        }
    }
}
exports.VpcEndpointService = VpcEndpointService;
_a = JSII_RTTI_SYMBOL_1;
VpcEndpointService[_a] = { fqn: "@aws-cdk/aws-ec2.VpcEndpointService", version: "1.163.1" };
//# sourceMappingURL=data:application/json;base64,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