/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  var define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
"ed583be1cf": function _(e,s,o,t,n){t();const i=e("tslib").__importStar(e("ea89eb96d7"));o.AwesomePanelExtensions=i;e("@bokehjs/base").register_models(i)},
"ea89eb96d7": function _(t,a,e,o,b){o(),b("FastAnchor",t("3ab92f5894").FastAnchor),b("FastButton",t("1d9a6373ec").FastButton),b("FastCheckboxGroup",t("b62557482c").FastCheckboxGroup),b("FastSwitchGroup",t("b714a2453d").FastSwitchGroup),b("FastTextAreaInput",t("e9b1cd48b7").FastTextAreaInput),b("FastTextInput",t("92a4b5b2b8").FastTextInput),b("PivotTable",t("eb2d75c5b0").PivotTable),b("Icon",t("5f262d0d3a").Icon),b("WebComponent",t("eae326731a").WebComponent)},
"3ab92f5894": function _(e,t,r,s,n){s();const i=e("@bokehjs/models/layouts/html_box");class o extends i.HTMLBoxView{setAttr(e,t){const r=this.anchor_el;null===t?r.setAttribute(e,!1):r.setAttribute(e,t)}connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,(()=>{null===this.model.name?this.anchor_el.innerHTML="":this.anchor_el.innerHTML=this.model.name})),this.connect(this.model.properties.appearance.change,(()=>{this.setAttr("appearance",this.model.appearance)})),this.connect(this.model.properties.href.change,(()=>{this.setAttr("href",this.model.href)})),this.connect(this.model.properties.hreflang.change,(()=>{this.setAttr("hreflang",this.model.hreflang)})),this.connect(this.model.properties.ping.change,(()=>{this.setAttr("ping",this.model.ping)})),this.connect(this.model.properties.href.change,(()=>{this.setAttr("referrerpolicy",this.model.referrerpolicy)})),this.connect(this.model.properties.download.change,(()=>{this.setAttr("download",this.model.download)})),this.connect(this.model.properties.referrer.change,(()=>{this.setAttr("referrer",this.model.referrer)})),this.connect(this.model.properties.rel.change,(()=>{this.setAttr("rel",this.model.rel)})),this.connect(this.model.properties.target.change,(()=>{this.setAttr("mimetype",this.model.mimetype)}))}render(){super.render();const e=document.createElement("fast-anchor");this.anchor_el=e,this.anchor_el.style.width="100%",this.el.appendChild(this.anchor_el),null!==this.model.name&&(this.anchor_el.innerHTML=this.model.name),null!==this.model.appearance&&(e.appearance=this.model.appearance),null!==this.model.href&&(e.href=this.model.href),null!==this.model.hreflang&&(e.hreflang=this.model.hreflang),null!==this.model.ping&&(e.ping=this.model.ping),null!==this.model.referrerpolicy&&(e.referrerpolicy=this.model.referrerpolicy),null!==this.model.download&&(e.download=this.model.download),null!==this.model.referrer&&(e.ref=this.model.referrer),null!==this.model.rel&&(e.rel=this.model.rel),null!==this.model.target&&(e.target=this.model.target),null!==this.model.mimetype&&(e.mimetype=this.model.mimetype)}}r.FastAnchorView=o,o.__name__="FastAnchorView";class h extends i.HTMLBox{constructor(e){super(e)}static init_FastAnchor(){this.prototype.default_view=o,this.define((({String:e})=>({appearance:[e],download:[e],href:[e],hreflang:[e],ping:[e],referrerpolicy:[e],referrer:[e],rel:[e],target:[e],mimetype:[e]})))}}r.FastAnchor=h,h.__name__="FastAnchor",h.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_anchor",h.init_FastAnchor()},
"1d9a6373ec": function _(t,e,n,s,o){s();const a=t("@bokehjs/models/widgets/button");class i extends a.ButtonView{_render_button(...t){const e=document.createElement("fast-button");return e.innerText=this.model.label,e.disabled=this.model.disabled,e.appearance=this.model.appearance,e.autofocus=this.model.autofocus,e.style.width="100%",e.style.height="100%",e}}n.FastButtonView=i,i.__name__="FastButtonView";class u extends a.Button{constructor(t){super(t)}static init_FastButton(){this.prototype.default_view=i,this.define((({Boolean:t,String:e})=>({appearance:[e,"neutral"],autofocus:[t,!1]})))}}n.FastButton=u,u.__name__="FastButton",u.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_button",u.init_FastButton()},
"b62557482c": function _(e,t,s,o,i){o();const n=e("tslib"),a=e("@bokehjs/models/widgets/checkbox_group"),c=n.__importStar(e("@bokehjs/styles/widgets/inputs.css")),l=e("@bokehjs/core/dom"),h=e("@bokehjs/core/util/array");class r extends a.CheckboxGroupView{render(){const e=l.div({class:[c.input_group,this.model.inline?c.inline:null]});this.el.innerHTML="",this.el.appendChild(e);const{active:t,labels:s}=this.model;this._inputs=[];for(let o=0;o<s.length;o++){let i=document.createElement("fast-checkbox");this.model.readonly&&i.setAttribute("readonly",!0),i.innerHTML=s[o];const n=i;n.value=`${o}`,n.addEventListener("change",(()=>this.change_active(o))),this._inputs.push(n),this.model.disabled&&(n.disabled=!0),h.includes(t,o)&&(n.checked=!0),e.appendChild(n)}}}s.FastCheckboxGroupView=r,r.__name__="FastCheckboxGroupView";class d extends a.CheckboxGroup{constructor(e){super(e)}static init_FastCheckboxGroup(){this.prototype.default_view=r,this.define((({Boolean:e})=>({readonly:[e]})))}}s.FastCheckboxGroup=d,d.__name__="FastCheckboxGroup",d.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_checkbox_group",d.init_FastCheckboxGroup()},
"b714a2453d": function _(e,t,s,i,n){i();const o=e("tslib"),c=e("@bokehjs/models/widgets/checkbox_group"),a=o.__importStar(e("@bokehjs/styles/widgets/inputs.css")),d=e("@bokehjs/core/dom"),h=e("@bokehjs/core/util/array");class l extends c.CheckboxGroupView{render(){const e=d.div({class:[a.input_group,this.model.inline?a.inline:null]});this.el.innerHTML="",this.el.appendChild(e);const{active:t,labels:s}=this.model;this._inputs=[];for(let i=0;i<s.length;i++){let n=document.createElement("fast-switch");this.model.readonly&&n.setAttribute("readonly",!0),n.innerHTML=s[i],n.innerHTML=s[i];const o=n;o.value=`${i}`,o.addEventListener("change",(()=>this.change_active(i))),this._inputs.push(o),this.model.disabled&&(o.disabled=!0),h.includes(t,i)&&(o.checked=!0);const c=document.createElement("span");c.setAttribute("slot","checked-message"),c.innerHTML=this.model.checked_message,o.appendChild(c);const a=document.createElement("span");a.setAttribute("slot","unchecked-message"),a.innerHTML=this.model.unchecked_message,o.appendChild(a),e.appendChild(o)}}}s.FastSwitchGroupView=l,l.__name__="FastSwitchGroupView";class r extends c.CheckboxGroup{constructor(e){super(e)}static init_FastSwitchGroup(){this.prototype.default_view=l,this.define((({Boolean:e,String:t})=>({readonly:[e],checked_message:[t],unchecked_message:[t]})))}}s.FastSwitchGroup=r,r.__name__="FastSwitchGroup",r.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_switch_group",r.init_FastSwitchGroup()},
"e9b1cd48b7": function _(e,t,i,s,n){s();const l=e("@bokehjs/models/widgets/textarea_input"),o=e("@bokehjs/models/widgets/input_widget");class h extends o.InputWidgetView{get input_el_any(){return this.input_el}connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,(()=>{var e;return this.input_el.name=null!==(e=this.model.name)&&void 0!==e?e:""})),this.connect(this.model.properties.value.change,(()=>{this.input_el.value=this.model.value})),this.connect(this.model.properties.disabled.change,(()=>this.input_el.disabled=this.model.disabled)),this.connect(this.model.properties.placeholder.change,(()=>this.input_el.placeholder=this.model.placeholder)),this.connect(this.model.properties.rows.change,(()=>this.input_el.rows=this.model.rows)),this.connect(this.model.properties.cols.change,(()=>this.input_el.cols=this.model.cols)),this.connect(this.model.properties.max_length.change,(()=>this.input_el_any.setAttribute("maxlength",this.model.max_length))),this.connect(this.model.properties.appearance.change,(()=>this.input_el_any.appearance=this.model.appearance)),this.connect(this.model.properties.autofocus.change,(()=>this.input_el_any.autofocus=this.model.autofocus)),this.connect(this.model.properties.resize.change,(()=>this.input_el_any.resize=this.model.resize)),this.connect(this.model.properties.spellcheck.change,(()=>this.input_el_any.spellcheck=this.model.spellcheck)),this.connect(this.model.properties.min_length.change,(()=>this.input_el_any.setAttribute("minlength",this.model.min_length))),this.connect(this.model.properties.required.change,(()=>this.input_el_any.required=this.model.required)),this.connect(this.model.properties.readonly.change,(()=>{!0===this.model.readonly?this.input_el_any.setAttribute("readonly",""):this.input_el_any.removeAttribute("readonly")}))}render(){super.render();const e=document.createElement("fast-text-area");this.input_el=e,this.input_el.className="bk-fast-input",this.input_el.addEventListener("change",(()=>this.change_input())),this.group_el.appendChild(this.input_el),e.name=this.model.name,e.value=this.model.value,e.disabled=this.model.disabled,e.placeholder=this.model.placeholder,e.cols=this.model.cols,e.rows=this.model.rows,null!=this.model.max_length&&e.setAttribute("maxlength",this.model.max_length),e.appearance=this.model.appearance,e.autofocus=this.model.autofocus,e.resize=this.model.resize,e.spellcheck=this.model.spellcheck,null!=this.model.min_length&&e.setAttribute("minlength",this.model.min_length),e.required=this.model.required,!0===this.model.readonly&&e.setAttribute("readonly","")}change_input(){this.model.value=this.input_el.value,super.change_input()}}i.FastTextAreaInputView=h,h.__name__="FastTextAreaInputView";class a extends l.TextAreaInput{constructor(e){super(e)}static init_FastTextAreaInput(){this.prototype.default_view=h,this.define((({Boolean:e,Number:t,String:i})=>({appearance:[i],autofocus:[e],resize:[i],spellcheck:[e],min_length:[t],required:[e],readonly:[e]})))}}i.FastTextAreaInput=a,a.__name__="FastTextAreaInput",a.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_textarea_input",a.init_FastTextAreaInput()},
"92a4b5b2b8": function _(e,t,i,n,s){n();const l=e("@bokehjs/models/widgets/text_input"),h=e("@bokehjs/models/widgets/input_widget");class a extends h.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,(()=>{var e;return this.input_el.name=null!==(e=this.model.name)&&void 0!==e?e:""})),this.connect(this.model.properties.value.change,(()=>{this.input_el.value=this.model.value,console.log("value")})),this.connect(this.model.properties.value_input.change,(()=>this.input_el.value=this.model.value_input)),this.connect(this.model.properties.disabled.change,(()=>this.input_el.disabled=this.model.disabled)),this.connect(this.model.properties.placeholder.change,(()=>this.input_el.placeholder=this.model.placeholder)),this.connect(this.model.properties.appearance.change,(()=>this.input_el_any.appearance=this.model.appearance)),this.connect(this.model.properties.autofocus.change,(()=>this.input_el_any.autofocus=this.model.autofocus)),this.connect(this.model.properties.type_of_text.change,(()=>this.input_el_any.type=this.model.type_of_text)),this.connect(this.model.properties.max_length.change,(()=>this.input_el_any.setAttribute("maxlength",this.model.max_length))),this.connect(this.model.properties.min_length.change,(()=>this.input_el_any.setAttribute("minlength",this.model.min_length))),this.connect(this.model.properties.pattern.change,(()=>this.input_el_any.pattern=this.model.pattern)),this.connect(this.model.properties.spellcheck.change,(()=>this.input_el_any.spellcheck=this.model.spellcheck)),this.connect(this.model.properties.required.change,(()=>this.input_el_any.required=this.model.required)),this.connect(this.model.properties.readonly.change,(()=>this.input_el_any.setAttribute("readonly",this.model.readonly)))}get input_el_any(){return this.input_el}render(){super.render();const e=document.createElement("fast-text-field");this.input_el=e,this.input_el.className="bk-fast-input",this.input_el.addEventListener("change",(()=>this.change_input())),this.input_el.addEventListener("input",(()=>this.change_input_oninput())),this.group_el.appendChild(this.input_el),e.name=this.model.name,e.value=this.model.value,e.appearance=this.model.appearance,e.autofocus=this.model.autofocus,e.placeholder=this.model.placeholder,e.disabled=this.model.disabled,e.type=this.model.type_of_text,e.setAttribute("maxlength",this.model.max_length),e.setAttribute("minlength",this.model.min_length),e.pattern=this.model.pattern,e.spellcheck=this.model.spellcheck,e.required=this.model.required,e.disabled=this.model.disabled,e.setAttribute("readonly",this.model.readonly)}change_input(){this.model.value=this.input_el.value,super.change_input()}change_input_oninput(){this.model.value_input=this.input_el.value,super.change_input()}}i.FastTextInputView=a,a.__name__="FastTextInputView";class o extends l.TextInput{constructor(e){super(e)}static init_FastTextInput(){this.prototype.default_view=a,this.define((({Any:e,Boolean:t,Number:i,String:n})=>({appearance:[n],autofocus:[t],type_of_text:[n],min_length:[i],pattern:[n],size:[e],spellcheck:[t],required:[t],readonly:[t,!1]})))}}i.FastTextInput=o,o.__name__="FastTextInput",o.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_text_input",o.init_FastTextInput()},
"eb2d75c5b0": function _(e,t,s,o,i){o();const a=e("@bokehjs/models/layouts/html_box"),n=e("@bokehjs/core/dom"),l=e("88538263fa");class _ extends a.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.source.properties.data.change,this.setData)}render(){super.render(),this.container=n.div({class:"pnx-pivot-table"}),l.set_size(this.container,this.model),this.el.appendChild(this.container),this.setData()}setData(){console.log("setData"),console.log(this.model.source.data);let e=l.transform_cds_to_records(this.model.source);this.pivot_table_element=$(this.container),console.log(e),this.pivot_table_element.pivotUI(e,{})}}s.PivotTableView=_,_.__name__="PivotTableView";class c extends a.HTMLBox{constructor(e){super(e)}static init_PivotTable(){this.prototype.default_view=_,this.define((({Any:e})=>({source:[e],source_stream:[e],source_patch:[e]})))}}s.PivotTable=c,c.__name__="PivotTable",c.__module__="awesome_panel_extensions.bokeh_extensions.pivot_table",c.init_PivotTable()},
"88538263fa": function _(e,t,i,l,n){l(),i.set_size=function(e,t){let i=null!=t.width?"fixed":"fit",l=null!=t.height?"fixed":"fit";const{sizing_mode:n}=t;if(null!=n)if("fixed"==n)i=l="fixed";else if("stretch_both"==n)i=l="max";else if("stretch_width"==n)i="max";else if("stretch_height"==n)l="max";else switch(n){case"scale_width":i="max",l="min";break;case"scale_height":i="min",l="max";break;case"scale_both":i="max",l="max";break;default:throw new Error("unreachable")}"fixed"==i&&t.width?e.style.width=t.width+"px":"max"==i&&(e.style.width="100%"),"fixed"==l&&t.height?e.style.height=t.height+"px":"max"==l&&(e.style.height="100%")},i.transform_cds_to_records=function(e){const t=[],i=e.columns(),l=e.get_length();if(0===i.length||null===l)return[];for(let n=0;n<l;n++){const l={};for(const t of i){let i=e.get_array(t);const s=null==i[0].shape?null:i[0].shape;null!=s&&s.length>1&&"number"==typeof s[0]?l[t]=i.slice(n*s[1],n*s[1]+s[1]):l[t]=i[n]}t.push(l)}return t},i.toAttribute=function(e,t){return null===t?"":("string"!=typeof t&&(t=JSON.stringify(t))," "+e+"='"+t+"'")}},
"5f262d0d3a": function _(t,e,i,n,s){n();const o=t("@bokehjs/models/widgets/abstract_icon");class l extends o.AbstractIconView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.render()))}render(){if(super.render(),null===this.model.text&&""===this.model.text)return;this.el.innerHTML="";const t=(e=this.model.text,i=document.createElement("template"),e=e.trim(),i.innerHTML=e,i.content.firstChild);var e,i;if(this.el.appendChild(t),this.el.style.display="inline",this.el.style.height=`${this.model.size}em`,this.el.style.width=`${this.model.size}em`,t.style.verticalAlign="middle",t.style.height=`${this.model.size}em`,t.style.width=`${this.model.size}em`,t.style.fill=this.model.fill_color,this.model.spin_duration>0){const e=`${this.model.spin_duration}ms`;t.style.setProperty("-webkit-animation-name","spin"),t.style.setProperty("-webkit-animation-duration",e),t.style.setProperty("-webkit-animation-iteration-count","infinite"),t.style.setProperty("-webkit-animation-timing-function","linear"),t.style.setProperty("-moz-animation-name","spin"),t.style.setProperty("-moz-animation-duration",e),t.style.setProperty("-moz-animation-iteration-count","infinite"),t.style.setProperty("-moz-animation-timing-function","linear"),t.style.setProperty("-ms-animation-name","spin"),t.style.setProperty("-ms-animation-duration",e),t.style.setProperty("-ms-animation-iteration-count","infinite"),t.style.setProperty("-ms-animation-timing-function","linear"),t.style.setProperty("animation-name","spin"),t.style.setProperty("animation-duration",e),t.style.setProperty("animation-iteration-count","infinite"),t.style.setProperty("animation-timing-function","linear")}if(t.classList.add("icon"),null!=this.model.label&&""!==this.model.label){const e=this.model.label.toLowerCase().replace(" ","");t.classList.add(`icon-${e}`)}}}i.IconView=l,l.__name__="IconView";class a extends o.AbstractIcon{constructor(t){super(t)}static init_Icon(){this.prototype.default_view=l,this.define((({String:t,Number:e,Int:i})=>({label:[t],text:[t],size:[e,1],fill_color:[t,"currentColor"],spin_duration:[i,0]})))}}i.Icon=a,a.__name__="Icon",a.__module__="awesome_panel_extensions.bokeh_extensions.icon",a.init_Icon()},
"eae326731a": function _(e,t,n,o,s){o();const i=e("tslib"),r=e("@bokehjs/core/dom"),a=e("@bokehjs/models/layouts/html_box"),l=i.__importStar(e("@bokehjs/styles/widgets/inputs.css"));function h(e){return(new DOMParser).parseFromString(e,"text/html").documentElement.textContent}class p extends a.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,(()=>this.handleNameChange())),this.connect(this.model.properties.innerHTML.change,(()=>this.render())),this.connect(this.model.properties.attributesLastChange.change,(()=>this.handleAttributesLastChangeChange())),this.connect(this.model.properties.propertiesLastChange.change,(()=>this.handlePropertiesLastChangeChange())),this.connect(this.model.properties.columnDataSource.change,(()=>this.handleColumnDataSourceChange()))}handleNameChange(){this.label_el&&(this.label_el.textContent=this.model.name)}render(){super.render(),this.el.innerHTML!==this.model.innerHTML&&this.createOrUpdateWebComponentElement()}after_layout(){"after_layout"in this.webComponentElement&&this.webComponentElement.after_layout()}createOrUpdateWebComponentElement(){this.webComponentElement&&(this.webComponentElement.onchange=null);const e=this.model.name;"inputgroup"===this.model.componentType&&e?(this.group_el=r.div({class:l.input_group},this.label_el),this.group_el.innerHTML=h(this.model.innerHTML),this.webComponentElement=this.group_el.firstElementChild,this.label_el=r.label({style:{display:0==e.length?"none":""}},e),this.group_el.insertBefore(this.label_el,this.webComponentElement),this.el.appendChild(this.group_el)):(this.el.innerHTML=h(this.model.innerHTML),this.webComponentElement=this.el.firstElementChild),this.activate_scripts(this.webComponentElement.parentNode),this.initPropertyValues(),this.handlePropertiesLastChangeChange(),this.handleColumnDataSourceChange(),this.webComponentElement.onchange=e=>this.handlePropertiesChange(e),this.addEventListeners(),this.addAttributesMutationObserver()}addAttributesMutationObserver(){if(!this.model.attributesToWatch)return;let e={childList:!1,attributes:!0,characterData:!1,subtree:!1,attributeFilter:Object.keys(this.model.attributesToWatch),attributeOldValue:!1,characterDataOldValue:!1};new MutationObserver((e=>{let t=new Object;for(let e in this.model.attributesToWatch){const n=this.webComponentElement.getAttribute(e);t[e]=n}this.model.attributesLastChange!==t&&(this.model.attributesLastChange=t)})).observe(this.webComponentElement,e)}addEventListeners(){this.eventsCount={};for(let e in this.model.eventsToWatch)this.eventsCount[e]=0,this.webComponentElement.addEventListener(e,(e=>this.eventHandler(e)),!1)}transform_cds_to_records(e){const t=[],n=e.columns(),o=e.get_length();if(0===n.length||null===o)return[];for(let s=0;s<o;s++){const o={};for(const t of n){let n=e.get_array(t);const i=null==n[0].shape?null:n[0].shape;null!=i&&i.length>1&&"number"==typeof i[0]?o[t]=n.slice(s*i[1],s*i[1]+i[1]):o[t]=n[s]}t.push(o)}return t}isFunction(e){if(e){const t={}.toString.call(e);return"[object Function]"===t||"[object AsyncFunction]"===t}return!1}handleColumnDataSourceChange(){if(this.model.columnDataSource){let e;if(e="records"===this.model.columnDataSourceOrient?this.transform_cds_to_records(this.model.columnDataSource):this.model.columnDataSource.data,null===this.model.columnDataSourceLoadFunction)return;const t=this.model.columnDataSourceLoadFunction.toString(),n=this.webComponentElement[t];this.isFunction(n)?this.webComponentElement[t](e):this.webComponentElement[t]=e}}activate_scripts(e){Array.from(e.querySelectorAll("script")).forEach((e=>{const t=document.createElement("script");Array.from(e.attributes).forEach((e=>t.setAttribute(e.name,e.value))),t.appendChild(document.createTextNode(e.innerHTML)),e.parentNode&&e.parentNode.replaceChild(t,e)}))}get_nested_property(e,t){let n=(t=(t=t.replace(/\[(\w+)\]/g,".$1")).replace(/^\./,"")).split(".");for(let t=0,o=n.length;t<o;++t){let o=n[t];if(!(o in e))return"";e=e[o]}return e}set_nested_property(e,t,n){const o=t.split(".");if(1===o.length)e[t]=n;else{const t=o.length;for(let n=0;n<t-1;n++){const t=o[n];e[t]||(e[t]={}),e=e[t]}e[o[t-1]]=n}}eventHandler(e){let t=e.type;this.eventsCount[t]+=1;let n={};n[t]=this.eventsCount[t],this.model.eventsCountLastChange=n,this.checkIfPropertiesChanged()}checkIfPropertiesChanged(){const e={};for(const t in this.model.propertiesToWatch){const n=this.propertyValues[t],o=this.get_nested_property(this.webComponentElement,t);n!=o&&(e[t]=o,this.propertyValues[t]=o)}Object.keys(e).length&&(this.model.propertiesLastChange=e)}handlePropertiesChange(e){const t=new Object;for(const n in this.model.propertiesToWatch)e.detail&&n in e.detail?(t[n]=e.detail[n],this.propertyValues[n]=e.detail[n]):e.target&&n in e.target&&(t[n]=e.target[n],this.propertyValues[n]=e.target[n]);Object.keys(t).length&&(this.model.propertiesLastChange=t)}initPropertyValues(){if(this.propertyValues=new Object,this.webComponentElement)for(let e in this.model.propertiesToWatch){let t=this.propertyValues[e],n=this.get_nested_property(this.webComponentElement,e);n!==t&&(this.propertyValues[e]=n)}}handleAttributesLastChangeChange(){if(!this.webComponentElement)return;let e=this.model.attributesLastChange;for(let t in this.model.attributesLastChange)if(t in this.model.attributesToWatch){let n=this.webComponentElement.getAttribute(t),o=e[t];n!==o&&(null===o?this.webComponentElement.removeAttribute(t):this.webComponentElement.setAttribute(t,o))}}handlePropertiesLastChangeChange(){if(!this.webComponentElement)return;let e=this.model.propertiesLastChange;for(let t in this.model.propertiesLastChange)if(t in this.model.propertiesToWatch){let n=e[t];this.set_nested_property(this.webComponentElement,t,n)}}}n.WebComponentView=p,p.__name__="WebComponentView";class m extends a.HTMLBox{constructor(e){super(e)}static init_WebComponent(){this.prototype.default_view=p,this.define((({Any:e,String:t})=>({componentType:[t,"htmlbox"],innerHTML:[t,""],attributesToWatch:[e],attributesLastChange:[e],propertiesToWatch:[e],propertiesLastChange:[e],eventsToWatch:[e],eventsCountLastChange:[e],columnDataSource:[e],columnDataSourceOrient:[e],columnDataSourceLoadFunction:[e]})))}}n.WebComponent=m,m.__name__="WebComponent",m.__module__="awesome_panel_extensions.bokeh_extensions.web_component",m.init_WebComponent()},
}, "ed583be1cf", {"index":"ed583be1cf","bokeh_extensions/index":"ea89eb96d7","bokeh_extensions/fast/fast_anchor":"3ab92f5894","bokeh_extensions/fast/fast_button":"1d9a6373ec","bokeh_extensions/fast/fast_checkbox_group":"b62557482c","bokeh_extensions/fast/fast_switch_group":"b714a2453d","bokeh_extensions/fast/fast_textarea_input":"e9b1cd48b7","bokeh_extensions/fast/fast_text_input":"92a4b5b2b8","bokeh_extensions/pivot_table":"eb2d75c5b0","bokeh_extensions/shared":"88538263fa","bokeh_extensions/icon":"5f262d0d3a","bokeh_extensions/web_component":"eae326731a"}, {});});
