#!/bin/bash

print_help() {
   echo "usage: install.sh [OPTION]

This script install the package from either TestPyPI (by default) or PyPI:
- https://test.pypi.org/project/autopilot-tools/
- https://pypi.org/project/autopilot-tools/

Options:
  --pypi    Install from PyPI instead of TestPyPI."
}

# Parse args
if [ ! "${BASH_SOURCE[0]}" -ef "$0" ]; then
    echo "You should execute this script, not source it!"
    return
elif [[ $1 == "--pypi" ]]; then
    echo Installing from PyPi...
    INDEX_URL=""   # empty means PyPi
elif [ ! -z $1 ]; then
    print_help
    exit
else
    echo Installing from TestPyPI...
    INDEX_URL="--index-url https://test.pypi.org/simple/"
fi

# Main
python3 -m pip install --upgrade $INDEX_URL --no-deps autopilot_tools
