#!/usr/bin/env python3
import os
import sys
import logging
from pathlib import Path
from time import time

from autopilot_tools.enums import Devices
from autopilot_tools.vehicle import Vehicle
from autopilot_tools.mavlink_ftp.ftp_filesystem import File

if __name__ == '__main__':
    vehicle: Vehicle = Vehicle()
    vehicle.connect(device=Devices.serial)
    print(f'Connected to {vehicle.autopilot}')

    log_folder = vehicle.get_log_folder()
    print(f'{log_folder}')

    list_dir = vehicle.mav_ftp.list_directory(log_folder)
    for dir in list_dir:
        print(f"- {dir['name']}")

    latest_file: File = vehicle.mav_ftp.get_last_log(log_folder)
    print(latest_file)
    start_time = time()
    latest_file.materialize()

    output = "latest_log.ulog"
    latest_file.save_locally(output)

    log_link = vehicle.analyze_log(latest_file.data)
    print(log_link)
