#!/usr/bin/env python3
import os
import sys
from pathlib import Path
from autopilot_tools.vehicle import Vehicle

def configure_example():
    vehicle = Vehicle()
    vehicle.connect()
    autopilot_firmware = vehicle.get_autopilot_type()

    if autopilot_firmware == "PX4":
        config_name = "config_px4.yaml"
    elif autopilot_firmware == "ArduPilot":
        config_name = "config_ardupilot.yaml"
    else:
        print("Unknown autopilot hardware. Exit.")
        return

    vehicle.configure(SCRIPT_DIR / config_name, reboot=False)

if __name__ == '__main__':
    configure_example()
