#!/usr/bin/env

"""
"""

import os
from os.path import join as pjoin
import logging

try:
    # Even though there is no "imcpipeline/_version" file,
    # it should be generated by
    # setuptools_scm when building the package
    from imcpipeline._version import __version__
except ImportError:
    from setuptools_scm import get_version as _get_version

    __version__ = _get_version(root="..", relative_to=__file__)


def setup_logging(level=logging.INFO):
    # create logger with 'imcpipeline'
    logger = logging.getLogger("imcpipeline")
    logger.setLevel(level)
    # create file handler which logs even debug messages
    fh = logging.FileHandler(pjoin(os.path.expanduser("~"), ".imcpipeline.log"))
    fh.setLevel(logging.DEBUG)
    # create console handler
    ch = logging.StreamHandler()
    ch.setLevel(level)
    # create formatter and add it to the handlers
    fmt = "imcpipeline.v{}:%(module)s:L%(lineno)d ".format(__version__)
    fmt += "(%(funcName)s) [%(levelname)s] %(asctime)s > %(message)s"
    formatter = logging.Formatter(fmt, datefmt="%Y-%m-%d %H:%M:%S")
    fh.setFormatter(formatter)
    ch.setFormatter(formatter)
    # add the handlers to the logger
    logger.addHandler(fh)
    logger.addHandler(ch)
    return logger


LOGGER = setup_logging()

DOCKER_IMAGE = "afrendeiro/cellprofiler"
DEMO_ILASTIK_MODEL = "https://wcm.box.com/shared/static/4rlm4ty6e0uaf35cp7sm279w3anyoz76.zip"
DEMO_DATA = "https://wcm.box.com/shared/static/wdbntdtsq95dfyffodiz7kb5bmdj5x5u"
DEMO_CSV = "https://wcm.box.com/shared/static/yy24b47sb730twi2zlmo3y4qvi7kc6xd"
