"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TestStack = exports.testFixtureCluster = exports.testFixtureNoVpc = exports.testFixture = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const CLUSTER_VERSION = lib_1.KubernetesVersion.V1_16;
function testFixture() {
    const { stack, app } = testFixtureNoVpc();
    const vpc = new ec2.Vpc(stack, 'VPC');
    return { stack, vpc, app };
}
exports.testFixture = testFixture;
function testFixtureNoVpc() {
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'Stack', { env: { region: 'us-east-1' } });
    return { stack, app };
}
exports.testFixtureNoVpc = testFixtureNoVpc;
function testFixtureCluster() {
    const { stack, app } = testFixtureNoVpc();
    const cluster = new lib_1.Cluster(stack, 'Cluster', { version: CLUSTER_VERSION });
    return { stack, app, cluster };
}
exports.testFixtureCluster = testFixtureCluster;
// we must specify an explicit environment because we have an AMI map that is
// keyed from the target region.
const env = {
    region: process.env.CDK_INTEG_REGION || process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_INTEG_ACCOUNT || process.env.CDK_DEFAULT_ACCOUNT,
};
class TestStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id, { env });
    }
}
exports.TestStack = TestStack;
//# sourceMappingURL=data:application/json;base64,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