"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const util_1 = require("./util");
/* eslint-disable max-len */
const CLUSTER_VERSION = lib_1.KubernetesVersion.V1_16;
module.exports = {
    'basic usage'(test) {
        // GIVEN
        const { stack } = util_1.testFixtureNoVpc();
        const cluster = new lib_1.Cluster(stack, 'cluster', { version: CLUSTER_VERSION });
        const manifest = [
            {
                apiVersion: 'v1',
                kind: 'Service',
                metadata: {
                    name: 'hello-kubernetes',
                },
                spec: {
                    type: 'LoadBalancer',
                    ports: [
                        { port: 80, targetPort: 8080 },
                    ],
                    selector: {
                        app: 'hello-kubernetes',
                    },
                },
            },
            {
                apiVersion: 'apps/v1',
                kind: 'Deployment',
                metadata: {
                    name: 'hello-kubernetes',
                },
                spec: {
                    replicas: 2,
                    selector: {
                        matchLabels: {
                            app: 'hello-kubernetes',
                        },
                    },
                    template: {
                        metadata: {
                            labels: {
                                app: 'hello-kubernetes',
                            },
                        },
                        spec: {
                            containers: [
                                {
                                    name: 'hello-kubernetes',
                                    image: 'paulbouwer/hello-kubernetes:1.5',
                                    ports: [
                                        { containerPort: 8080 },
                                    ],
                                },
                            ],
                        },
                    },
                },
            },
        ];
        // WHEN
        new lib_1.KubernetesManifest(stack, 'manifest', {
            cluster,
            manifest,
        });
        assert_1.expect(stack).to(assert_1.haveResource(lib_1.KubernetesManifest.RESOURCE_TYPE, {
            Manifest: JSON.stringify(manifest),
        }));
        test.done();
    },
    'can be added to an imported cluster with minimal config'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        const cluster = lib_1.Cluster.fromClusterAttributes(stack, 'MyCluster', {
            clusterName: 'my-cluster-name',
            kubectlRoleArn: 'arn:aws:iam::1111111:role/iam-role-that-has-masters-access',
        });
        // WHEN
        cluster.addManifest('foo', { bar: 2334 });
        cluster.addHelmChart('helm', { chart: 'hello-world' });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource(lib_1.KubernetesManifest.RESOURCE_TYPE, {
            Manifest: '[{"bar":2334}]',
            ClusterName: 'my-cluster-name',
            RoleArn: 'arn:aws:iam::1111111:role/iam-role-that-has-masters-access',
        }));
        assert_1.expect(stack).to(assert_1.haveResource(lib_1.HelmChart.RESOURCE_TYPE, {
            ClusterName: 'my-cluster-name',
            RoleArn: 'arn:aws:iam::1111111:role/iam-role-that-has-masters-access',
            Release: 'myclustercharthelm78d2c26a',
            Chart: 'hello-world',
            Namespace: 'default',
            CreateNamespace: true,
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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