"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ pragma:ignore-assets
const core_1 = require("@aws-cdk/core");
const eks = require("../lib");
const util_1 = require("./util");
class EksFargateClusterStack extends util_1.TestStack {
    constructor(scope, id) {
        super(scope, id);
        new eks.FargateCluster(this, 'FargateCluster', {
            version: eks.KubernetesVersion.V1_17,
        });
    }
}
const app = new core_1.App();
new EksFargateClusterStack(app, 'aws-cdk-eks-fargate-cluster-test');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZmFyZ2F0ZS1jbHVzdGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuZmFyZ2F0ZS1jbHVzdGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsbUNBQW1DO0FBQ25DLHdDQUFvQztBQUNwQyw4QkFBOEI7QUFDOUIsaUNBQW1DO0FBRW5DLE1BQU0sc0JBQXVCLFNBQVEsZ0JBQVM7SUFFNUMsWUFBWSxLQUFVLEVBQUUsRUFBVTtRQUNoQyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksR0FBRyxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLEVBQUU7WUFDN0MsT0FBTyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLO1NBQ3JDLENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQUVELE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7QUFFdEIsSUFBSSxzQkFBc0IsQ0FBQyxHQUFHLEVBQUUsa0NBQWtDLENBQUMsQ0FBQztBQUVwRSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLy8gIWNkay1pbnRlZyBwcmFnbWE6aWdub3JlLWFzc2V0c1xuaW1wb3J0IHsgQXBwIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBla3MgZnJvbSAnLi4vbGliJztcbmltcG9ydCB7IFRlc3RTdGFjayB9IGZyb20gJy4vdXRpbCc7XG5cbmNsYXNzIEVrc0ZhcmdhdGVDbHVzdGVyU3RhY2sgZXh0ZW5kcyBUZXN0U3RhY2sge1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBBcHAsIGlkOiBzdHJpbmcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgbmV3IGVrcy5GYXJnYXRlQ2x1c3Rlcih0aGlzLCAnRmFyZ2F0ZUNsdXN0ZXInLCB7XG4gICAgICB2ZXJzaW9uOiBla3MuS3ViZXJuZXRlc1ZlcnNpb24uVjFfMTcsXG4gICAgfSk7XG4gIH1cbn1cblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuXG5uZXcgRWtzRmFyZ2F0ZUNsdXN0ZXJTdGFjayhhcHAsICdhd3MtY2RrLWVrcy1mYXJnYXRlLWNsdXN0ZXItdGVzdCcpO1xuXG5hcHAuc3ludGgoKTsiXX0=