import * as cdk from '@aws-cdk/core';
/**
 * @experimental
 */
export interface Notification {
    /**
     * (experimental) Prefix title for slack message.
     *
     * @experimental
     */
    readonly stageName?: string;
    /**
     * (experimental) Slack webhook url.
     *
     * @experimental
     */
    readonly slackWebHookUrl?: string;
}
/**
 * @experimental
 */
export interface GitHubTokenFromSecretsManager {
    /**
     * (experimental) Arn with other type of secrets.
     *
     * @experimental
     */
    readonly secretsManagerArn?: string;
    /**
     * (experimental) SecretKey.
     *
     * @experimental
     */
    readonly secretKey?: string;
}
/**
 * @experimental
 */
export interface CodePipelineBadgeNotificationProps {
    /**
     * (experimental) AWS CodePipeline arn.
     *
     * @experimental
     */
    readonly pipelineArn: string;
    /**
     * (experimental) AWS Secret Manager id or arn.
     *
     * @experimental
     */
    readonly gitHubTokenFromSecretsManager?: GitHubTokenFromSecretsManager;
    /**
     * (experimental) Notification.
     *
     * @experimental
     */
    readonly notification?: Notification;
}
/**
 * @experimental
 */
export declare class CodePipelineBadgeNotification extends cdk.Construct {
    /**
     * @experimental
     */
    badgeUrl: string;
    /**
     * @experimental
     */
    codePipelineLink: string;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: CodePipelineBadgeNotificationProps);
    private createCodePipelineEventLambdaFunction;
    private tagResource;
}
