
# 🛠️ Project Badges
[![GitHub](https://img.shields.io/github/v/release/Stoupy51/stouputils?logo=github&label=GitHub)](https://github.com/Stoupy51/stouputils/releases/latest)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/stouputils?logo=python&label=PyPI%20downloads)](https://pypi.org/project/stouputils/)
[![Documentation](https://img.shields.io/github/v/release/Stoupy51/stouputils?logo=sphinx&label=Documentation&color=purple)](https://stoupy51.github.io/stouputils/latest/)


# 📚 Project Overview
Stouputils is a collection of utility modules designed to simplify and enhance the development process.<br>
It includes a range of tools for tasks such as execution of doctests, display utilities, decorators, as well as context managers.


# 🚀 Project File Tree
```bash
stouputils/
├── applications/
│   ├── automatic_docs.py    # 📚 Documentation generation utilities (used to create this documentation)
│   └── ...
│
├── continuous_delivery/
│   ├── cd_utils.py          # 🔧 Common utilities for continuous delivery
│   ├── github.py            # 📦 GitHub utilities (upload_to_github)
│   ├── pypi.py              # 📦 PyPI utilities (pypi_full_routine)
│   ├── pyproject.py         # 📝 Pyproject.toml utilities
│   └── ...
│
├── print.py                 # 🖨️ Display utilities (info, debug, warning, error)
├── io.py                    # 💻 I/O utilities (file management, json)
├── decorators.py            # 🎯 Decorators (silent, measure_time, error_handler, simple_cache)
├── ctx.py                   # 🚫 Context managers (Muffle, LogToFile)
├── archive.py               # 📦 Archive utilities (zip, repair_zip)
├── parallel.py              # 🧑‍🤝‍🧑 Parallel processing (multiprocessing, multithreading)
├── collections.py           # 🧰 Collection utilities (unique_list)
├── all_doctests.py          # ✅ Execution of all doctests for a given path
├── backup.py                # 📦 Backup utilities (delta backup, consolidate)
└── ...
```


## ⭐ Star History

<html>
  <a href="https://star-history.com/#Stoupy51/stouputils&Date">
    <picture>
      <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=Stoupy51/stouputils&type=Date&theme=dark" />
      <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=Stoupy51/stouputils&type=Date" />
      <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=Stoupy51/stouputils&type=Date" />
    </picture>
  </a>
</html>

