# Generated by Django 3.2.6 on 2021-08-13 15:41
import django.db.models.deletion
from django.conf import settings
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="ImportJob",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "file",
                    models.FileField(
                        max_length=255,
                        upload_to="django-import-export-dramatiq-import-jobs",
                        verbose_name="File to be imported",
                    ),
                ),
                (
                    "processing_initiated",
                    models.DateTimeField(
                        blank=True,
                        default=None,
                        null=True,
                        verbose_name="Have we started processing the file? If so when?",
                    ),
                ),
                (
                    "imported",
                    models.DateTimeField(
                        blank=True,
                        default=None,
                        null=True,
                        verbose_name="Has the import been completed? If so when?",
                    ),
                ),
                (
                    "format",
                    models.CharField(
                        max_length=255,
                        verbose_name="Format of file to be imported",
                    ),
                ),
                (
                    "change_summary",
                    models.FileField(
                        blank=True,
                        null=True,
                        upload_to="django-import-export-dramatiq-import-change-summaries",
                        verbose_name="Summary of changes made by this import",
                    ),
                ),
                ("errors", models.TextField(blank=True, default="")),
                (
                    "model",
                    models.CharField(
                        choices=[],
                        max_length=160,
                        verbose_name="Name of model to import to",
                    ),
                ),
                (
                    "job_status",
                    models.CharField(
                        blank=True,
                        max_length=160,
                        verbose_name="Status of the job",
                    ),
                ),
                (
                    "author",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="importjob_create",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="author",
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="importjob_update",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="last updated by",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ExportJob",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "file",
                    models.FileField(
                        max_length=255,
                        upload_to="django-import-export-dramatiq-export-jobs",
                        verbose_name="exported file",
                    ),
                ),
                (
                    "processing_initiated",
                    models.DateTimeField(
                        blank=True,
                        default=None,
                        null=True,
                        verbose_name="Have we started processing the file? If so when?",
                    ),
                ),
                (
                    "job_status",
                    models.CharField(
                        blank=True,
                        max_length=160,
                        verbose_name="Status of the job",
                    ),
                ),
                (
                    "format",
                    models.CharField(
                        max_length=255,
                        null=True,
                        verbose_name="Format of file to be exported",
                    ),
                ),
                (
                    "app_label",
                    models.CharField(
                        max_length=160,
                        verbose_name="App label of model to export from",
                    ),
                ),
                (
                    "model",
                    models.CharField(
                        max_length=160,
                        verbose_name="Name of model to export from",
                    ),
                ),
                (
                    "resource",
                    models.CharField(
                        default="",
                        max_length=255,
                        verbose_name="Resource to use when exporting",
                    ),
                ),
                (
                    "queryset",
                    models.TextField(
                        verbose_name="JSON list of pks to export",
                    ),
                ),
                (
                    "email_on_completion",
                    models.BooleanField(
                        default=True,
                        verbose_name="Send me an email when this export job is complete",
                    ),
                ),
                (
                    "site_of_origin",
                    models.TextField(default="", max_length=255),
                ),
                (
                    "author",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="exportjob_create",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="author",
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="exportjob_update",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="last updated by",
                    ),
                ),
            ],
        ),
    ]
