from ..utils.utils import generateNodeId



class Node:
    """
    Class that represents a single vertex in a heterogeneous information network. 
    """

    id: str
    """Unique id of the vertex. Gets autogenerated by util function."""

    type: str
    """Type of the vertex. Required."""

    attributes: dict
    """Dictionary of attributes with the attribute identifiers as keys."""

    def __init__(self, type: str, attributes: dict = {}) -> None:
        """
        Maps parameters and attributes on object construction. 

        Parameters
        ---------
            type : str
                Type of the vertex
            attributes : dict
                Dictionary of vertex attributes. Attribute identifier are used as keys and the attributes acutal value as dict values.
        """
        self.id = generateNodeId()
        self.type = type

        self.attributes = attributes