
<div id="top"></div>
<!--
*** Thanks for checking out the Best-README-Template. If you have a suggestion
*** that would make this better, please fork the repo and create a pull request
*** or simply open an issue with the tag "enhancement".
*** Don't forget to give the project a star!
*** Thanks again! Now go create something AMAZING! :D
-->



<!-- PROJECT SHIELDS -->
<!--
*** I'm using markdown "reference style" links for readability.
*** Reference links are enclosed in brackets [ ] instead of parentheses ( ).
*** See the bottom of this document for the declaration of the reference variables
*** for contributors-url, forks-url, etc. This is an optional, concise syntax you may use.
*** https://www.markdownguide.org/basic-syntax/#reference-style-links
-->

[![LinkedIn][linkedin-shield]][linkedin-url]



<!-- PROJECT LOGO -->
<br />
<div align="center">
 
<h1 align="center"><b>GithubDepCheck</b></h1>

  <p align="center">
    CLI Tool to check the dependencies of github repositories and create a pull request if packages need to get updated.
    <br />
    <a href="https://github.com/dyte-submissions/dyte-vit-2022-Shubh0405"><strong>Explore the docs »</strong></a>
    <br />
    <br />
    <a href="https://github.com/dyte-submissions/dyte-vit-2022-Shubh0405">View Demo</a>
    ·
    <a href="https://github.com/dyte-submissions/dyte-vit-2022-Shubh0405/issues">Report Bug</a>
    ·
    <a href="https://github.com/dyte-submissions/dyte-vit-2022-Shubh0405/issues">Request Feature</a>
  </p>
</div>



<!-- TABLE OF CONTENTS -->
<details>
  <summary>Table of Contents</summary>
  <ol>
    <li>
      <a href="#about-the-project">About The Project</a>
      <ul>
        <li><a href="#built-with">Built With Python</a></li>
      </ul>
    </li>
    <li>
      <a href="#getting-started">Getting Started</a>
      <ul>
        <li><a href="#prerequisites">Prerequisites</a></li>
        <li><a href="#installation">Installation</a></li>
      </ul>
    </li>
    <li><a href="#usage">Usage</a></li>
    <li><a href="#contributing">Contributing</a></li>
    <li><a href="#license">License</a></li>
    <li><a href="#contact">Contact</a></li>
    <li><a href="#acknowledgments">Acknowledgments</a></li>
  </ol>
</details>



<!-- ABOUT THE PROJECT -->
## About The Project

<p align="center">
  <img width="600" height="400" src="https://user-images.githubusercontent.com/59278577/171269819-14e7d1cf-ceb2-454b-920a-8895d490ede1.png">
</p>

GithubDepCheck is a cli tool which helps you check if dependecies of your node.js projects are up-to-date or not. If they are not up-to-date, githubdepcheck updates the package and creates a pull request on your github repository. All you need to do is pass a csv file containing the link to your github repository and package name and version that you want to check in all your repositories.

<p align="right">(<a href="#top">back to top</a>)</p>



### Built With

* [Python](https://www.python.org/)

<p align="right">(<a href="#top">back to top</a>)</p>



<!-- GETTING STARTED -->
## Getting Started

Following contains the prerequisites, installation and usage guide for for githubdepcheck

### Prerequisites

You need to have following things installed: 
1. [Pip (Package Installer for python)](https://pypi.org/project/pip/)
2. Git
  ```sh
  sudo apt-get install git
  ```
3. [Node and npm](https://docs.npmjs.com/downloading-and-installing-node-js-and-npm)

### Installation

Create a virtual environment and install the githubdepcheck package using pip.

```sh
pip install githubdepchecker
```

<p align="right">(<a href="#top">back to top</a>)</p>



<!-- USAGE EXAMPLES -->
## Usage

You need to first configure your github username and password to be able to check dependencies on private repositories and create pull requests on others repositories. If github username and password are not configured, it will first ask for it and automatically configure it.

### To check your cofigured github username and password:
```sh
githubdepchecker --getgitconfig
```

### To set or change your github username and password:
```sh
githubdepchecker --setgitconfig <github-username> <github-password>
```

### To perform dependency check of multiple github repositories:

1. Create a csv file with following headers and enter the rows accordingly.

![image](https://user-images.githubusercontent.com/59278577/171265766-5d221f3f-5ddc-48e8-819d-85fe87a4f7e2.png)

2. Enter the following command with csv path and dependency name and version for which you want to perform dependency check.

```sh
githubdepchecker -i '/home/user/Download/githubrepos.csv' axios@0.23.0
```

3. Above command will create an output file on home directory with an extra column of version_satisfied

![image](https://user-images.githubusercontent.com/59278577/171266474-0deab356-ff3f-4907-ab36-ee313c8fba85.png)

### To create pull request for updating dependency on github repositories:

1. Add --update on the command given in previous step.

```sh
githubdepchecker -i '/home/user/Download/githubrepos.csv' axios@0.23.0 --update
```

2. Above command will create an output file on home directory with an extra column of update_pr

![image](https://user-images.githubusercontent.com/59278577/171267031-bb7415ef-ebe8-45c2-82ff-25968d0970e2.png)

**Note:** If csv file contains your own github repository whose dependencies needs to be updated, then it will not create any
pull request, instead it will stop the process after committing the files as you don't need to create pull request for updating your own repository.

### To create csv for above steps

If you feel lazy creating csv with repositories names and links, then don't worry githubdepcheck got your back :) Run the following command and it will generate an repositories.csv file on your home directory containing all your github repositories name and link whose language is JavaScript.

```sh
githubdepchecker --createcsv
```

To get the csv for repositories of an organization, run the following command:

```sh
githubdepchecker --createcsv --org <organization-name>
```


<p align="right">(<a href="#top">back to top</a>)</p>

<!-- CONTRIBUTING -->
## Contributing

Contributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**.

If you have a suggestion that would make this better, please fork the repo and create a pull request. You can also simply open an issue with the tag "enhancement".
Don't forget to give the project a star! Thanks again!

1. Fork the Project
2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the Branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

<p align="right">(<a href="#top">back to top</a>)</p>



<!-- LICENSE -->
## License

Distributed under the MIT License. See `LICENSE.txt` for more information.

<p align="right">(<a href="#top">back to top</a>)</p>



<!-- CONTACT -->
## Contact

Your Name - [@linkedin_handle](https://www.linkedin.com/in/shubhgupta04/) - shubhngupta04@gmail.com

Project Link: [https://github.com/dyte-submissions/dyte-vit-2022-Shubh0405](https://github.com/dyte-submissions/dyte-vit-2022-Shubh0405)

<p align="right">(<a href="#top">back to top</a>)</p>



<!-- ACKNOWLEDGMENTS -->
## Acknowledgments

- I would like to thank dyte recruitment team to give this challenging task. It was fun working on this task as I wanted to do something different for a long time :)

<p align="right">(<a href="#top">back to top</a>)</p>



<!-- MARKDOWN LINKS & IMAGES -->
<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->
[contributors-shield]: https://img.shields.io/github/contributors/dyte-submissions/dyte-vit-2022-Shubh0405.svg?style=for-the-badge
[contributors-url]: https://github.com/dyte-submissions/dyte-vit-2022-Shubh0405/graphs/contributors
[forks-shield]: https://img.shields.io/github/forks/dyte-submissions/dyte-vit-2022-Shubh0405.svg?style=for-the-badge
[forks-url]: https://github.com/dyte-submissions/dyte-vit-2022-Shubh0405/network/members
[stars-shield]: https://img.shields.io/github/stars/dyte-submissions/dyte-vit-2022-Shubh0405.svg?style=for-the-badge
[stars-url]: https://github.com/dyte-submissions/dyte-vit-2022-Shubh0405/stargazers
[issues-shield]: https://img.shields.io/github/issues/dyte-submissions/dyte-vit-2022-Shubh0405.svg?style=for-the-badge
[issues-url]: https://github.com/dyte-submissions/dyte-vit-2022-Shubh0405/issues
[license-shield]: https://img.shields.io/github/license/dyte-submissions/dyte-vit-2022-Shubh0405.svg?style=for-the-badge
[license-url]: https://github.com/dyte-submissions/dyte-vit-2022-Shubh0405/blob/master/LICENSE.txt
[linkedin-shield]: https://img.shields.io/badge/-LinkedIn-black.svg?style=for-the-badge&logo=linkedin&colorB=555
[linkedin-url]: https://www.linkedin.com/in/shubhgupta04/
[product-screenshot]: images/screenshot.png
