# Pragmatic
An environment of tooling around C++.

# Whishlist
### Whishlist: Core values
 - [ ] Only pay for what you use.
### Whishlist: Convenience
 - [ ] Include files from web.
 - [ ] Include what you use (IWYU).
### Whishlist: Build system
 - [ ] All build steps, targets should be able to be defined in code, without external languae syntax.
 - [ ] Simple programs should be easy to build.
 - [ ] Large projects should be straight forward to build.
 - [ ] Fast incremental builds.
 - [ ] Trivial large build description.
 - [ ] Code imported to Pragmatic c++ should be easy.
 - [ ] Pragmatic c++ should interop with existing build systems.
 - [ ] Clang first approach, multi compiler support.
 - [ ] Background compiler.
 - [ ] Language server extensions.
### Whishlist: Dynamics
 - [ ] Implemented as scriptable compiler plugins.
 - [ ] Reflection over types.
 - [ ] Bytecode emission.
 - [ ] Run time types.
 - [ ] User defined attributes.
 - [ ] Burst JIT.
 - [ ] Hooks, mocks & wrappers.
### Whishlist: Memory
 - [ ] Allocator modules.
 - [ ] Allocation instrumentation.
 - [ ] Static smart pointer analyser (borrow mechanism).
### Whishlist: Concurrency
 - [ ] Fibers.
 - [ ] Thread pools.
### Whishlist: GPU
 - [ ] Shader reflection.
 - [ ] Seamless graphics API.
### Whishlist: Collections
 - [ ] Slices.
 - [ ] Queries.
### Whishlist: Documentation
 - [ ] General doc gen.
 - [ ] Test example code.
### Whishlist: Python interop
 - [ ] Python based macros.
 - [ ] Simple python c++ extension module build.
 - [ ] Extend build steps with Python.
### Whishlist: IDE interop
 - [ ] Debug whole pipeline.
 - [ ] Visualize build steps.
