# collibra-search
<p>The Search API allows you to create your own integration with the Collibra Search Engine.<br /> Find your data!</p>

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import collibra_search
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import collibra_search
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import collibra_search
from collibra_search.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rest/2.0
# See configuration.py for a list of all supported configuration parameters.
configuration = collibra_search.Configuration(
    host = "http://localhost/rest/2.0"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = collibra_search.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure Bearer authorization (JWT): bearerAuth
configuration = collibra_search.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with collibra_search.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = collibra_search.SearchApi(api_client)
    offset = 0 # int | The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>. (optional) (default to 0)
limit = 0 # int | The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used. (optional) (default to 0)
count_limit = -1 # int | Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped (optional) (default to -1)
name = 'name_example' # str | The search term for a search view to retrieve.<br /> The query is case sensitive and does not support wildcards.<br /> Use in conjunction with `nameMatchMode`. (optional)
name_match_mode = 'ANYWHERE' # str | The match requirements for `name` queries.<br /> Works in conjunction with `name`. The search is case-sensitive. (optional) (default to 'ANYWHERE')
sort_field = 'NAME' # str | The reference field for sorting the results. (optional) (default to 'NAME')
sort_order = 'ASC' # str | The order in which the results are sorted. (optional) (default to 'ASC')

    try:
        # Lists search views.
        api_response = api_instance.find_views(offset=offset, limit=limit, count_limit=count_limit, name=name, name_match_mode=name_match_mode, sort_field=sort_field, sort_order=sort_order)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling SearchApi->find_views: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/rest/2.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*SearchApi* | [**find_views**](docs/SearchApi.md#find_views) | **GET** /search/views | Lists search views.
*SearchApi* | [**get_view**](docs/SearchApi.md#get_view) | **GET** /search/views/{viewId} | Returns the details of an existing search view.
*SearchApi* | [**search**](docs/SearchApi.md#search) | **POST** /search | Search.


## Documentation For Models

 - [FindSearchViewsRequest](docs/FindSearchViewsRequest.md)
 - [PagedResponseSearchView](docs/PagedResponseSearchView.md)
 - [SearchAggregation](docs/SearchAggregation.md)
 - [SearchAssetResultResource](docs/SearchAssetResultResource.md)
 - [SearchAssetResultResourceAllOf](docs/SearchAssetResultResourceAllOf.md)
 - [SearchCommunityResultResource](docs/SearchCommunityResultResource.md)
 - [SearchDomainResultResource](docs/SearchDomainResultResource.md)
 - [SearchDomainResultResourceAllOf](docs/SearchDomainResultResourceAllOf.md)
 - [SearchFilter](docs/SearchFilter.md)
 - [SearchHighlight](docs/SearchHighlight.md)
 - [SearchInFields](docs/SearchInFields.md)
 - [SearchRequest](docs/SearchRequest.md)
 - [SearchResponse](docs/SearchResponse.md)
 - [SearchResponseAggregation](docs/SearchResponseAggregation.md)
 - [SearchResponseAggregationValue](docs/SearchResponseAggregationValue.md)
 - [SearchResult](docs/SearchResult.md)
 - [SearchResultHighlight](docs/SearchResultHighlight.md)
 - [SearchResultResource](docs/SearchResultResource.md)
 - [SearchResultStatus](docs/SearchResultStatus.md)
 - [SearchResultType](docs/SearchResultType.md)
 - [SearchUserGroupResultResource](docs/SearchUserGroupResultResource.md)
 - [SearchUserResultResource](docs/SearchUserResultResource.md)
 - [SearchView](docs/SearchView.md)
 - [SearchViewPagedResponse](docs/SearchViewPagedResponse.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## bearerAuth

- **Type**: Bearer authentication (JWT)


## Author




