import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataHashicupsCoffeesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hashicups/d/coffees#id DataHashicupsCoffees#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataHashicupsCoffeesCoffeesIngredients {
}
export declare function dataHashicupsCoffeesCoffeesIngredientsToTerraform(struct?: DataHashicupsCoffeesCoffeesIngredients): any;
export declare class DataHashicupsCoffeesCoffeesIngredientsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataHashicupsCoffeesCoffeesIngredients | undefined;
    set internalValue(value: DataHashicupsCoffeesCoffeesIngredients | undefined);
    get ingredientId(): number;
}
export declare class DataHashicupsCoffeesCoffeesIngredientsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataHashicupsCoffeesCoffeesIngredientsOutputReference;
}
export interface DataHashicupsCoffeesCoffees {
}
export declare function dataHashicupsCoffeesCoffeesToTerraform(struct?: DataHashicupsCoffeesCoffees): any;
export declare class DataHashicupsCoffeesCoffeesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataHashicupsCoffeesCoffees | undefined;
    set internalValue(value: DataHashicupsCoffeesCoffees | undefined);
    get description(): string;
    get id(): number;
    get image(): string;
    private _ingredients;
    get ingredients(): DataHashicupsCoffeesCoffeesIngredientsList;
    get name(): string;
    get price(): number;
    get teaser(): string;
}
export declare class DataHashicupsCoffeesCoffeesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataHashicupsCoffeesCoffeesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/hashicups/d/coffees hashicups_coffees}
*/
export declare class DataHashicupsCoffees extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "hashicups_coffees";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/hashicups/d/coffees hashicups_coffees} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataHashicupsCoffeesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataHashicupsCoffeesConfig);
    private _coffees;
    get coffees(): DataHashicupsCoffeesCoffeesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
