# django-cache-toolbox

_Non-magical object caching for Django._

Another caching framework for Django that does not do any magic behind your
back, saving brain cycles when debugging as well as sticking to Django
principles.

## Installation

From [PyPI](https://pypi.org/project/django-cache-toolbox/):
```
pip install django-cache-toolbox
```

## Basic Usage

``` python
from cache_toolbox import cache_model, cache_relation
from django.db import models

class Foo(models.Model):
    ...

class Bazz(models.Model):
    foo = models.OneToOneField(Foo, related_name='bazz')
    ...

# Prepare caching of a model
cache_model(Foo)

# Prepare caching of a relation
cache_relation(Foo.bazz)

# Fetch the cached version of a model
foo = Foo.get_cached(pk=42)

# Load a cached relation
print(foo.bazz_cache)
```

See the module docstrings for further details.
