import { JsonObject } from './safe-json-parse';
interface JwtHeaderStandardFields {
    alg?: 'RS256' | 'RS384' | 'RS512' | string;
    kid?: string;
}
export declare type JwtHeader = JwtHeaderStandardFields & JsonObject;
interface JwtPayloadStandardFields {
    exp?: number;
    iss?: string;
    aud?: string | string[];
    nbf?: number;
    iat?: number;
    scope?: string;
    jti?: string;
}
export declare type JwtPayload = JwtPayloadStandardFields & JsonObject;
export interface Jwt {
    header: JwtHeader;
    payload: JwtPayload;
}
export declare type CognitoIdOrAccessTokenPayload<IssuerConfig, VerifyProps> = VerifyProps extends {
    tokenUse: null;
} ? CognitoJwtPayload : VerifyProps extends {
    tokenUse: 'id';
} ? CognitoIdTokenPayload : VerifyProps extends {
    tokenUse: 'access';
} ? CognitoAccessTokenPayload : IssuerConfig extends {
    tokenUse: 'id';
} ? CognitoIdTokenPayload : IssuerConfig extends {
    tokenUse: 'access';
} ? CognitoAccessTokenPayload : CognitoJwtPayload;
interface CognitoJwtFields {
    token_use: 'access' | 'id';
    'cognito:groups'?: string[];
    sub: string;
    iss: string;
    exp: number;
    iat: number;
    auth_time: number;
    jti: string;
    origin_jti: string;
}
export declare type CognitoJwtPayload = CognitoJwtFields & JsonObject;
interface CognitoIdTokenFields extends CognitoJwtFields {
    token_use: 'id';
    aud: string;
    at_hash: string;
    'cognito:username': string;
    email_verified: boolean;
    phone_number_verified: boolean;
    identities: {
        userId: string;
        providerName: string;
        providerType: string;
        issuer: null;
        primary: string;
        dateCreated: string;
    }[];
    'cognito:roles': string[];
    'cognito:preferred_role': string;
}
export declare type CognitoIdTokenPayload = CognitoIdTokenFields & JsonObject;
interface CognitoAccessTokenFields extends CognitoJwtFields {
    token_use: 'access';
    client_id: string;
    version: number;
    username: string;
    scope: string;
}
export declare type CognitoAccessTokenPayload = CognitoAccessTokenFields & JsonObject;
export interface CognitoJwt {
    header: JwtHeader;
    payload: CognitoAccessTokenPayload | CognitoIdTokenPayload;
}
export {};
