import { Component } from './component';
import { Project } from './project';
/**
 * (experimental) Options for `SourceCodeFile`.
 *
 * @experimental
 */
export interface SourceCodeOptions {
    /**
     * (experimental) Indentation size.
     *
     * @default 2
     * @experimental
     */
    readonly indent?: number;
}
/**
 * (experimental) Represents a source file.
 *
 * @experimental
 */
export declare class SourceCode extends Component {
    private readonly file;
    private indentLevel;
    private readonly indent;
    /**
     * @experimental
     */
    constructor(project: Project, filePath: string, options?: SourceCodeOptions);
    /**
     * (experimental) Emit a line of code.
     *
     * @param code The contents, if not specified, just adds a newline.
     * @experimental
     */
    line(code?: string): void;
    /**
     * (experimental) Opens a code block and increases the indentation level.
     *
     * @param code The code before the block starts (e.g. `export class {`).
     * @experimental
     */
    open(code?: string): void;
    /**
     * (experimental) Decreases the indentation level and closes a code block.
     *
     * @param code The code after the block is closed (e.g. `}`).
     * @experimental
     */
    close(code?: string): void;
}
