"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReceiptRuleSet = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const receipt_rule_1 = require("./receipt-rule");
const ses_generated_1 = require("./ses.generated");
/**
 * A new or imported receipt rule set.
 */
class ReceiptRuleSetBase extends core_1.Resource {
    /**
     * Adds a new receipt rule in this rule set. The new rule is added after
     * the last added rule unless `after` is specified.
     */
    addRule(id, options) {
        this.lastAddedRule = new receipt_rule_1.ReceiptRule(this, id, {
            after: this.lastAddedRule ?? undefined,
            ruleSet: this,
            ...options,
        });
        return this.lastAddedRule;
    }
    /**
     * Adds a drop spam rule
     */
    addDropSpamRule() {
        const dropSpam = new receipt_rule_1.DropSpamReceiptRule(this, 'DropSpam', {
            ruleSet: this,
        });
        this.lastAddedRule = dropSpam.rule;
    }
}
/**
 * A new receipt rule set.
 */
class ReceiptRuleSet extends ReceiptRuleSetBase {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptRuleSetName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_ReceiptRuleSetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ReceiptRuleSet);
            }
            throw error;
        }
        const resource = new ses_generated_1.CfnReceiptRuleSet(this, 'Resource', {
            ruleSetName: this.physicalName,
        });
        this.receiptRuleSetName = resource.ref;
        if (props) {
            if (props.dropSpam) {
                this.addDropSpamRule();
            }
            const rules = props.rules || [];
            rules.forEach((ruleOption, idx) => this.addRule(`Rule${idx}`, ruleOption));
        }
    }
    /**
     * Import an exported receipt rule set.
     */
    static fromReceiptRuleSetName(scope, id, receiptRuleSetName) {
        class Import extends ReceiptRuleSetBase {
            constructor() {
                super(...arguments);
                this.receiptRuleSetName = receiptRuleSetName;
            }
        }
        return new Import(scope, id);
    }
}
exports.ReceiptRuleSet = ReceiptRuleSet;
_a = JSII_RTTI_SYMBOL_1;
ReceiptRuleSet[_a] = { fqn: "@aws-cdk/aws-ses.ReceiptRuleSet", version: "1.184.1" };
//# sourceMappingURL=data:application/json;base64,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