# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/05_cassini_uvis.ipynb (unless otherwise specified).

__all__ = ['storage_root', 'get_user_guide', 'DataManager', 'get_data_path', 'get_label_path']

# Cell
from .pds.opusapi import OPUS
from .utils import url_retrieve, have_internet
from .config import config
from yarl import URL
import tomlkit
from fastcore.utils import Path

# Cell
storage_root = config.storage_root / "cassini/uvis"
storage_root

# Cell
def get_user_guide():
    url = URL("https://pds-rings.seti.org/cassini/uvis/1-UVIS_Users_Guide_-2018-Jan%2015-For%20PDS-REV-2018-07-06.pdf")
    local_path = storage_root / "uvis_user_guide.pdf"
    if not local_path.exists():
        url_retrieve(url, storage_root / "uvis_user_guide.pdf")
    return local_path

# Cell
class DataManager:
    def __init__(self, pid):
        self.pid = pid
        if not self.raw_data_path.exists():
            self.download()

    def query_pid(self, pid):
        opus = OPUS(silent=True)
        try:
            self.query_result = opus.query_image_id(pid)[0]
        except IndexError:
            raise FileNotFoundError("Project ID not found on PDS server.")
        self.opus_id = self.query_result[0]
        self.dict = self.query_result[1]

    @property
    def pds_id(self):
        return self.pid[:17]

    @property
    def folder(self):
        #         return storage_root / "/".join(self.raw_data_url.parts[4:7])
        return storage_root / self.pds_id

    @property
    def raw_data_url(self):
        return URL(self.dict["couvis_raw"][0])

    @property
    def raw_label_url(self):
        return URL(self.dict["couvis_raw"][1])

    @property
    def raw_data_path(self):
        return self.folder / (self.pds_id + ".DAT")

    @property
    def raw_label_path(self):
        return self.raw_data_path.with_suffix(".LBL")

    @property
    def calib_corr_path(self):
        return self.raw_data_path.with_name(self.raw_data_path.stem + "_CAL_3.DAT")

    @property
    def calib_label_path(self):
        return self.calib_corr_path.with_suffix(".LBL")

    @property
    def original_pid_file(self):
        return self.folder / "original_pid.txt"

    @property
    def results_file(self):
        return self.folder / "urls.toml"

    def download(self, overwrite=False):
        if self.raw_data_path.exists() and not overwrite:
            print("Local files exists. Use `overwrite=True` to download fresh.")
            return
        self.query_pid(self.pds_id)
        self.original_pid_file.mk_write(self.pid)
        self.results_file.mk_write(tomlkit.dumps(self.dict))
        self.raw_data_path.parent.mkdir(parents=True, exist_ok=True)
        for key in ["couvis_raw", "couvis_calib_corr"]:
            for url in self.dict[key]:
                url_retrieve(url, self.folder / URL(url).name)

    def __repr__(self):
        s = f"Product ID:\n{self.id}\n\n"
        for k, v in self.query_result[1].items():
            s += f"Key: {k},\nValue(s):\n{v}\n\n"
        return s

# Cell
def get_data_path(pid):
    dm = DataManager(pid)
    return dm.raw_data_path

def get_label_path(pid):
    dm = DataManager(pid)
    return dm.raw_label_path