# -*- coding: utf-8 -*-
# from __future__ import unicode_literals

import sys, os

extensions = []
templates_path = []

from atelier.sphinxconf import configure
configure(globals())

# extensions += ['atelier.sphinxconf.blog']
# extensions += ['lino.utils.actordoc']
# extensions += ['sphinxcontrib.taglist']
extensions += ['atelier.sphinxconf.complex_tables']
extensions += ['lino.sphinxcontrib.logo']
extensions += ['lino.sphinxcontrib.base']
# extensions += ['sphinxcontrib.youtube']

from atelier.sphinxconf import interproject
interproject.configure(
    globals(), 'atelier etgen lino_tera')



# If your extensions are in another directory, add it here. If the directory
# is relative to the documentation root, use os.path.abspath to make it
# absolute, like shown here.
#sys.path.append(os.path.abspath('some/directory'))

# General configuration
# ---------------------

# Add any paths that contain templates here, relative to this directory.
# templates_path = ['.templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
#source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = 'index'

# General substitutions.
project = u'Lino Tera Benutzerhandbuch'
copyright = '2018 Rumma & Ko Ltd'

from lino_tera import SETUP_INFO

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = SETUP_INFO['version']
# The full version, including alpha/beta/rc tags.
release = version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = str('de')

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%d.%B.%Y'


# Note 20100703 : unused_docs and exclude_trees  replaced by exclude_patterns

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['.build']

# List of documents that shouldn't be included in the build.
#unused_docs = []

# List of directories, relative to source directories, that shouldn't be searched
# for source files.
exclude_trees = ['old', 'include', '.build']


# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = str('sphinx')

# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []

# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
# html_theme = 'default'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
#html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = u"Lino Tera Benutzerhandbuch"

# A shorter title for the navigation bar.  Default is the same as html_title.
html_short_title = u"Home"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['.static']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
html_last_updated_fmt = str('%d.%m.%Y')
#~ html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True


# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
html_use_modindex = False

# If false, no index is generated.
html_use_index = False

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, the reST sources are included in the HTML build as _sources/<name>.
#html_copy_source = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# If nonempty, this is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = ''

# Output file base name for HTML help builder.
#htmlhelp_basename = 'saffre-rumma'


# Options for LaTeX output
# ------------------------

# The paper size ('letter' or 'a4').
#latex_paper_size = 'letter'

# The font size ('10pt', '11pt' or '12pt').
#latex_font_size = '10pt'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, document class [howto/manual]).
latex_documents = [
  ('index', 'saffre-rumma.tex', u'saffre-rumma',
   u'saffre-rumma', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#latex_use_parts = False

# Additional stuff for the LaTeX preamble.
#latex_preamble = ''

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
#latex_use_modindex = True


# http://ablog.readthedocs.org/manual/ablog-configuration-options/
# locale_dirs = []
# from os.path import join, dirname
# ld = join(dirname(ablog.__file__), 'locale')
# locale_dirs.append(ld)


sidebars = []
# sidebars += ['about.html']
# sidebars += ['quicklinks.html']
# sidebars += ['localtoc.html']
# sidebars += ['sidebarhelp.html']
# sidebars += ['searchbox.html']
# sidebars += ['postcard.html']
# sidebars += ['recentposts.html']
# sidebars += ['archives.html']
# sidebars += ['tagcloud.html', 'categories.html']
sidebars += ['globaltoc.html']
sidebars += ['links.html']

html_sidebars = {
    '**': sidebars,
    # '**': ['globaltoc.html'] + sidebars,
    # 'index': sidebars
}



# thanks to http://stackoverflow.com/questions/12772927/specifying-an-online-image-in-sphinx-restructuredtext-format :
import sphinx.environment
from docutils.utils import get_source_line

def _warn_node(self, msg, node, **kwargs):
    if not msg.startswith('nonlocal image URI found:'):
        self._warnfunc(msg, '%s:%s' % get_source_line(node), **kwargs)

sphinx.environment.BuildEnvironment.warn_node = _warn_node

