# coding: utf-8

"""
    Home Connect API

    This API provides access to home appliances enabled by Home Connect (https://home-connect.com). Through the API programs can be started and stopped, or home appliances configured and monitored. For instance, you can start a cotton program on a washer and get a notification when the cycle is complete.  To get started with this web client, visit https://developer.home-connect.com and register an account. An application with a client ID for this API client will be automatically generated for you.  In order to use this API in your own client, you need an OAuth 2 client implementing the authorization code grant flow (https://developer.home-connect.com/docs/authorization/flow).   More details can be found here: https://www.rfc-editor.org/rfc/rfc6749.txt  Authorization URL: https://api.home-connect.com/security/oauth/authorize  Token URL: https://api.home-connect.com/security/oauth/token   # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from home_connect_sdk.configuration import Configuration


class ProgramDefinitionData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'key': 'str',
        'name': 'str',
        'options': 'list[ProgramDefinitionDataOptions]'
    }

    attribute_map = {
        'key': 'key',
        'name': 'name',
        'options': 'options'
    }

    def __init__(self, key=None, name=None, options=None, local_vars_configuration=None):  # noqa: E501
        """ProgramDefinitionData - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._key = None
        self._name = None
        self._options = None
        self.discriminator = None

        self.key = key
        if name is not None:
            self.name = name
        if options is not None:
            self.options = options

    @property
    def key(self):
        """Gets the key of this ProgramDefinitionData.  # noqa: E501

        a key identifying an available program  # noqa: E501

        :return: The key of this ProgramDefinitionData.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this ProgramDefinitionData.

        a key identifying an available program  # noqa: E501

        :param key: The key of this ProgramDefinitionData.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and key is None:  # noqa: E501
            raise ValueError("Invalid value for `key`, must not be `None`")  # noqa: E501

        self._key = key

    @property
    def name(self):
        """Gets the name of this ProgramDefinitionData.  # noqa: E501

        user-friendly, localized name of the program, e.g. \"4D Heißluft\" in German  # noqa: E501

        :return: The name of this ProgramDefinitionData.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProgramDefinitionData.

        user-friendly, localized name of the program, e.g. \"4D Heißluft\" in German  # noqa: E501

        :param name: The name of this ProgramDefinitionData.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def options(self):
        """Gets the options of this ProgramDefinitionData.  # noqa: E501


        :return: The options of this ProgramDefinitionData.  # noqa: E501
        :rtype: list[ProgramDefinitionDataOptions]
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this ProgramDefinitionData.


        :param options: The options of this ProgramDefinitionData.  # noqa: E501
        :type: list[ProgramDefinitionDataOptions]
        """

        self._options = options

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProgramDefinitionData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ProgramDefinitionData):
            return True

        return self.to_dict() != other.to_dict()
