# coding: utf-8

"""
    Home Connect API

    This API provides access to home appliances enabled by Home Connect (https://home-connect.com). Through the API programs can be started and stopped, or home appliances configured and monitored. For instance, you can start a cotton program on a washer and get a notification when the cycle is complete.  To get started with this web client, visit https://developer.home-connect.com and register an account. An application with a client ID for this API client will be automatically generated for you.  In order to use this API in your own client, you need an OAuth 2 client implementing the authorization code grant flow (https://developer.home-connect.com/docs/authorization/flow).   More details can be found here: https://www.rfc-editor.org/rfc/rfc6749.txt  Authorization URL: https://api.home-connect.com/security/oauth/authorize  Token URL: https://api.home-connect.com/security/oauth/token   # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from home_connect_sdk.configuration import Configuration


class ArrayOfProgramsDataConstraints(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'available': 'bool',
        'execution': 'str'
    }

    attribute_map = {
        'available': 'available',
        'execution': 'execution'
    }

    def __init__(self, available=None, execution=None, local_vars_configuration=None):  # noqa: E501
        """ArrayOfProgramsDataConstraints - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._available = None
        self._execution = None
        self.discriminator = None

        if available is not None:
            self.available = available
        if execution is not None:
            self.execution = execution

    @property
    def available(self):
        """Gets the available of this ArrayOfProgramsDataConstraints.  # noqa: E501

        availability of the program   # noqa: E501

        :return: The available of this ArrayOfProgramsDataConstraints.  # noqa: E501
        :rtype: bool
        """
        return self._available

    @available.setter
    def available(self, available):
        """Sets the available of this ArrayOfProgramsDataConstraints.

        availability of the program   # noqa: E501

        :param available: The available of this ArrayOfProgramsDataConstraints.  # noqa: E501
        :type: bool
        """

        self._available = available

    @property
    def execution(self):
        """Gets the execution of this ArrayOfProgramsDataConstraints.  # noqa: E501

        execution right of the program, possible values: none, selectonly, startonly, selectandstart   # noqa: E501

        :return: The execution of this ArrayOfProgramsDataConstraints.  # noqa: E501
        :rtype: str
        """
        return self._execution

    @execution.setter
    def execution(self, execution):
        """Sets the execution of this ArrayOfProgramsDataConstraints.

        execution right of the program, possible values: none, selectonly, startonly, selectandstart   # noqa: E501

        :param execution: The execution of this ArrayOfProgramsDataConstraints.  # noqa: E501
        :type: str
        """
        allowed_values = ["none", "selectonly", "startonly", "selectandstart"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and execution not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `execution` ({0}), must be one of {1}"  # noqa: E501
                .format(execution, allowed_values)
            )

        self._execution = execution

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ArrayOfProgramsDataConstraints):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ArrayOfProgramsDataConstraints):
            return True

        return self.to_dict() != other.to_dict()
