# coding: utf-8

"""
    Home Connect API

    This API provides access to home appliances enabled by Home Connect (https://home-connect.com). Through the API programs can be started and stopped, or home appliances configured and monitored. For instance, you can start a cotton program on a washer and get a notification when the cycle is complete.  To get started with this web client, visit https://developer.home-connect.com and register an account. An application with a client ID for this API client will be automatically generated for you.  In order to use this API in your own client, you need an OAuth 2 client implementing the authorization code grant flow (https://developer.home-connect.com/docs/authorization/flow).   More details can be found here: https://www.rfc-editor.org/rfc/rfc6749.txt  Authorization URL: https://api.home-connect.com/security/oauth/authorize  Token URL: https://api.home-connect.com/security/oauth/token   # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from home_connect_sdk.api_client import ApiClient
from home_connect_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ProgramsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_active_program(self, haid, **kwargs):  # noqa: E501
        """Get program which is currently executed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_program(haid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Program
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_active_program_with_http_info(haid, **kwargs)  # noqa: E501

    def get_active_program_with_http_info(self, haid, **kwargs):  # noqa: E501
        """Get program which is currently executed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_program_with_http_info(haid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Program, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active_program" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `get_active_program`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/active', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Program',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_active_program_option(self, haid, optionkey, **kwargs):  # noqa: E501
        """Get one specific option of the active program, e.g. the duration.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_program_option(haid, optionkey, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str optionkey: Key of the option, e.g. BSH.Common.Option.Duration (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Option
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_active_program_option_with_http_info(haid, optionkey, **kwargs)  # noqa: E501

    def get_active_program_option_with_http_info(self, haid, optionkey, **kwargs):  # noqa: E501
        """Get one specific option of the active program, e.g. the duration.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_program_option_with_http_info(haid, optionkey, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str optionkey: Key of the option, e.g. BSH.Common.Option.Duration (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Option, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'optionkey',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active_program_option" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `get_active_program_option`")  # noqa: E501
        # verify the required parameter 'optionkey' is set
        if self.api_client.client_side_validation and ('optionkey' not in local_var_params or  # noqa: E501
                                                        local_var_params['optionkey'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `optionkey` when calling `get_active_program_option`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501
        if 'optionkey' in local_var_params:
            path_params['optionkey'] = local_var_params['optionkey']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/active/options/{optionkey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Option',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_active_program_options(self, haid, **kwargs):  # noqa: E501
        """Get all options of the active program like temperature or duration.  # noqa: E501

        You can retrieve a list of options of the currently running program.  For detailed documentation of the available options, visit the appliance-specific programs pages: * [Oven](https://developer.home-connect.com/docs/oven/supported_programs_and_options) * [Dishwasher](https://developer.home-connect.com/docs/dishwasher/supported_programs_options) * [Washer](https://developer.home-connect.com/docs/washing-machine/supported_programs_and_options) * [Dryer](https://developer.home-connect.com/docs/dryer/supported_programs_and_options) * [Coffee Machine](https://developer.home-connect.com/docs/coffee-maker/supported_programs_and_options) * [Hood](https://developer.home-connect.com/docs/hood/supported_programs_and_options) * [Cleaning Robot](https://developer.home-connect.com/docs/cleaningrobot/supported_programs_and_options)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_program_options(haid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ArrayOfOptions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_active_program_options_with_http_info(haid, **kwargs)  # noqa: E501

    def get_active_program_options_with_http_info(self, haid, **kwargs):  # noqa: E501
        """Get all options of the active program like temperature or duration.  # noqa: E501

        You can retrieve a list of options of the currently running program.  For detailed documentation of the available options, visit the appliance-specific programs pages: * [Oven](https://developer.home-connect.com/docs/oven/supported_programs_and_options) * [Dishwasher](https://developer.home-connect.com/docs/dishwasher/supported_programs_options) * [Washer](https://developer.home-connect.com/docs/washing-machine/supported_programs_and_options) * [Dryer](https://developer.home-connect.com/docs/dryer/supported_programs_and_options) * [Coffee Machine](https://developer.home-connect.com/docs/coffee-maker/supported_programs_and_options) * [Hood](https://developer.home-connect.com/docs/hood/supported_programs_and_options) * [Cleaning Robot](https://developer.home-connect.com/docs/cleaningrobot/supported_programs_and_options)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_program_options_with_http_info(haid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ArrayOfOptions, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active_program_options" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `get_active_program_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/active/options', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArrayOfOptions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_programs(self, haid, **kwargs):  # noqa: E501
        """Get all programs of a given home appliance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_programs(haid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ArrayOfPrograms
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_programs_with_http_info(haid, **kwargs)  # noqa: E501

    def get_all_programs_with_http_info(self, haid, **kwargs):  # noqa: E501
        """Get all programs of a given home appliance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_programs_with_http_info(haid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ArrayOfPrograms, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_programs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `get_all_programs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArrayOfPrograms',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_available_program(self, haid, programkey, **kwargs):  # noqa: E501
        """Get specific available program  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_available_program(haid, programkey, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str programkey: key of specific program to return (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ProgramDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_available_program_with_http_info(haid, programkey, **kwargs)  # noqa: E501

    def get_available_program_with_http_info(self, haid, programkey, **kwargs):  # noqa: E501
        """Get specific available program  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_available_program_with_http_info(haid, programkey, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str programkey: key of specific program to return (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ProgramDefinition, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'programkey',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_available_program" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `get_available_program`")  # noqa: E501
        # verify the required parameter 'programkey' is set
        if self.api_client.client_side_validation and ('programkey' not in local_var_params or  # noqa: E501
                                                        local_var_params['programkey'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `programkey` when calling `get_available_program`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501
        if 'programkey' in local_var_params:
            path_params['programkey'] = local_var_params['programkey']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/available/{programkey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProgramDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_available_programs(self, haid, **kwargs):  # noqa: E501
        """Get all programs which are currently available on the given home appliance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_available_programs(haid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ArrayOfAvailablePrograms
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_available_programs_with_http_info(haid, **kwargs)  # noqa: E501

    def get_available_programs_with_http_info(self, haid, **kwargs):  # noqa: E501
        """Get all programs which are currently available on the given home appliance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_available_programs_with_http_info(haid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ArrayOfAvailablePrograms, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_available_programs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `get_available_programs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/available', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArrayOfAvailablePrograms',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_selected_program(self, haid, **kwargs):  # noqa: E501
        """Get the program which is currently selected   # noqa: E501

        In most cases the selected program is the program which is currently shown on the display of the home appliance. This program can then be manually adjusted or started on the home appliance itself.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_selected_program(haid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Program
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_selected_program_with_http_info(haid, **kwargs)  # noqa: E501

    def get_selected_program_with_http_info(self, haid, **kwargs):  # noqa: E501
        """Get the program which is currently selected   # noqa: E501

        In most cases the selected program is the program which is currently shown on the display of the home appliance. This program can then be manually adjusted or started on the home appliance itself.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_selected_program_with_http_info(haid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Program, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_selected_program" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `get_selected_program`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/selected', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Program',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_selected_program_option(self, haid, optionkey, **kwargs):  # noqa: E501
        """Get specific option of selected program  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_selected_program_option(haid, optionkey, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str optionkey: Feature Key of the option as defined in FMF, e.g. BSH.Common.Option.Duration (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Option
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_selected_program_option_with_http_info(haid, optionkey, **kwargs)  # noqa: E501

    def get_selected_program_option_with_http_info(self, haid, optionkey, **kwargs):  # noqa: E501
        """Get specific option of selected program  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_selected_program_option_with_http_info(haid, optionkey, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str optionkey: Feature Key of the option as defined in FMF, e.g. BSH.Common.Option.Duration (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Option, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'optionkey',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_selected_program_option" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `get_selected_program_option`")  # noqa: E501
        # verify the required parameter 'optionkey' is set
        if self.api_client.client_side_validation and ('optionkey' not in local_var_params or  # noqa: E501
                                                        local_var_params['optionkey'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `optionkey` when calling `get_selected_program_option`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501
        if 'optionkey' in local_var_params:
            path_params['optionkey'] = local_var_params['optionkey']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/selected/options/{optionkey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Option',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_selected_program_options(self, haid, **kwargs):  # noqa: E501
        """Get all options of selected program  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_selected_program_options(haid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ArrayOfOptions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_selected_program_options_with_http_info(haid, **kwargs)  # noqa: E501

    def get_selected_program_options_with_http_info(self, haid, **kwargs):  # noqa: E501
        """Get all options of selected program  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_selected_program_options_with_http_info(haid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ArrayOfOptions, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_selected_program_options" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `get_selected_program_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/selected/options', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArrayOfOptions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_active_program_option(self, haid, optionkey, body, **kwargs):  # noqa: E501
        """Set one specific option of the active program  # noqa: E501

        This operation can be used to modify one specific option of the active program, e.g. to extend the duration of the active program by another 5 minutes.  Please note that changing options of the running program is currently only supported by ovens.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_active_program_option(haid, optionkey, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str optionkey: Key of the option, e.g. BSH.Common.Option.Duration (required)
        :param Option body: option of the active program to set (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_active_program_option_with_http_info(haid, optionkey, body, **kwargs)  # noqa: E501

    def set_active_program_option_with_http_info(self, haid, optionkey, body, **kwargs):  # noqa: E501
        """Set one specific option of the active program  # noqa: E501

        This operation can be used to modify one specific option of the active program, e.g. to extend the duration of the active program by another 5 minutes.  Please note that changing options of the running program is currently only supported by ovens.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_active_program_option_with_http_info(haid, optionkey, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str optionkey: Key of the option, e.g. BSH.Common.Option.Duration (required)
        :param Option body: option of the active program to set (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'optionkey',
            'body',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_active_program_option" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `set_active_program_option`")  # noqa: E501
        # verify the required parameter 'optionkey' is set
        if self.api_client.client_side_validation and ('optionkey' not in local_var_params or  # noqa: E501
                                                        local_var_params['optionkey'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `optionkey` when calling `set_active_program_option`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `set_active_program_option`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501
        if 'optionkey' in local_var_params:
            path_params['optionkey'] = local_var_params['optionkey']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/active/options/{optionkey}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_active_program_options(self, haid, body, **kwargs):  # noqa: E501
        """Set all options of the active program, e.g. to switch from preheating to the actual program options.  # noqa: E501

        Update the options for the currently running program. With this API endpoint, you have to provide all options with their new values. If you want to update only one option, you can use the endpoint specific to that option.  Please note that changing options of the running program is currently only supported by ovens.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_active_program_options(haid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param ArrayOfOptions body: list of options (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_active_program_options_with_http_info(haid, body, **kwargs)  # noqa: E501

    def set_active_program_options_with_http_info(self, haid, body, **kwargs):  # noqa: E501
        """Set all options of the active program, e.g. to switch from preheating to the actual program options.  # noqa: E501

        Update the options for the currently running program. With this API endpoint, you have to provide all options with their new values. If you want to update only one option, you can use the endpoint specific to that option.  Please note that changing options of the running program is currently only supported by ovens.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_active_program_options_with_http_info(haid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param ArrayOfOptions body: list of options (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'body',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_active_program_options" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `set_active_program_options`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `set_active_program_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/active/options', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_selected_program(self, haid, body, **kwargs):  # noqa: E501
        """Select a program  # noqa: E501

        In most cases the selected program is the program which is currently shown on the display of the home appliance. This program can then be manually adjusted or started on the home appliance itself.  A selected program will not be started automatically. You don't have to set a program as selected first if you intend to start it via API - you can set it directly as active program.  Selecting a program will update the available options and constraints directly from the home appliance. Any changes to the available options due to the state of the appliance is only reflected in the selected program.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_selected_program(haid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param Program body: program to select (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_selected_program_with_http_info(haid, body, **kwargs)  # noqa: E501

    def set_selected_program_with_http_info(self, haid, body, **kwargs):  # noqa: E501
        """Select a program  # noqa: E501

        In most cases the selected program is the program which is currently shown on the display of the home appliance. This program can then be manually adjusted or started on the home appliance itself.  A selected program will not be started automatically. You don't have to set a program as selected first if you intend to start it via API - you can set it directly as active program.  Selecting a program will update the available options and constraints directly from the home appliance. Any changes to the available options due to the state of the appliance is only reflected in the selected program.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_selected_program_with_http_info(haid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param Program body: program to select (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'body',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_selected_program" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `set_selected_program`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `set_selected_program`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/selected', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_selected_program_option(self, haid, optionkey, body, **kwargs):  # noqa: E501
        """Set specific option of selected program  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_selected_program_option(haid, optionkey, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str optionkey: Feature Key of the option as defined in FMF, e.g. BSH.Common.Option.Duration (required)
        :param Option body: description of the program to activate (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_selected_program_option_with_http_info(haid, optionkey, body, **kwargs)  # noqa: E501

    def set_selected_program_option_with_http_info(self, haid, optionkey, body, **kwargs):  # noqa: E501
        """Set specific option of selected program  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_selected_program_option_with_http_info(haid, optionkey, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str optionkey: Feature Key of the option as defined in FMF, e.g. BSH.Common.Option.Duration (required)
        :param Option body: description of the program to activate (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'optionkey',
            'body',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_selected_program_option" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `set_selected_program_option`")  # noqa: E501
        # verify the required parameter 'optionkey' is set
        if self.api_client.client_side_validation and ('optionkey' not in local_var_params or  # noqa: E501
                                                        local_var_params['optionkey'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `optionkey` when calling `set_selected_program_option`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `set_selected_program_option`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501
        if 'optionkey' in local_var_params:
            path_params['optionkey'] = local_var_params['optionkey']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/selected/options/{optionkey}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_selected_program_options(self, haid, body, **kwargs):  # noqa: E501
        """Set all options of selected program  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_selected_program_options(haid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param ArrayOfOptions body: description of the program to activate (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_selected_program_options_with_http_info(haid, body, **kwargs)  # noqa: E501

    def set_selected_program_options_with_http_info(self, haid, body, **kwargs):  # noqa: E501
        """Set all options of selected program  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_selected_program_options_with_http_info(haid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param ArrayOfOptions body: description of the program to activate (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'body',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_selected_program_options" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `set_selected_program_options`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `set_selected_program_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/selected/options', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start_program(self, haid, body, **kwargs):  # noqa: E501
        """Start the given program  # noqa: E501

        By putting a program object to this endpoint, the system will try to start it if all preconditions are fulfilled: * Home appliance is connected * *Remote Control* and *Remote Control Start Allowed* is enabled * No other program is currently active  Furthermore, the program must exist on the home appliance and its options must be set correctly. Keys of program, which can be exected on an oven, are for instance: * *Cooking.Oven.Program.HeatingMode.HotAir* * *Cooking.Oven.Program.HeatingMode.TopBottomHeating* * *Cooking.Oven.Program.HeatingMode.PizzaSetting* * *Cooking.Oven.Program.HeatingMode.PreHeating*  Keys for options of these oven programs are: * *Cooking.Oven.Option.SetpointTemperature*: 30 - 250 °C * *BSH.Common.Option.Duration*: 1 - 86340 seconds  For further documentation, visit the appliance-specific programs pages: * [Oven](https://developer.home-connect.com/docs/oven/supported_programs_and_options) * [Dishwasher](https://developer.home-connect.com/docs/dishwasher/supported_programs_options) * [Washer](https://developer.home-connect.com/docs/washing-machine/supported_programs_and_options) * [Dryer](https://developer.home-connect.com/docs/dryer/supported_programs_and_options) * [Coffee Machine](https://developer.home-connect.com/docs/coffee-maker/supported_programs_and_options) * [Hood](https://developer.home-connect.com/docs/hood/supported_programs_and_options) * [Cleaning Robot](https://developer.home-connect.com/docs/cleaningrobot/supported_programs_and_options)  There are no programs available for fridges and hobs.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_program(haid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param Program body: description of the program to activate (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.start_program_with_http_info(haid, body, **kwargs)  # noqa: E501

    def start_program_with_http_info(self, haid, body, **kwargs):  # noqa: E501
        """Start the given program  # noqa: E501

        By putting a program object to this endpoint, the system will try to start it if all preconditions are fulfilled: * Home appliance is connected * *Remote Control* and *Remote Control Start Allowed* is enabled * No other program is currently active  Furthermore, the program must exist on the home appliance and its options must be set correctly. Keys of program, which can be exected on an oven, are for instance: * *Cooking.Oven.Program.HeatingMode.HotAir* * *Cooking.Oven.Program.HeatingMode.TopBottomHeating* * *Cooking.Oven.Program.HeatingMode.PizzaSetting* * *Cooking.Oven.Program.HeatingMode.PreHeating*  Keys for options of these oven programs are: * *Cooking.Oven.Option.SetpointTemperature*: 30 - 250 °C * *BSH.Common.Option.Duration*: 1 - 86340 seconds  For further documentation, visit the appliance-specific programs pages: * [Oven](https://developer.home-connect.com/docs/oven/supported_programs_and_options) * [Dishwasher](https://developer.home-connect.com/docs/dishwasher/supported_programs_options) * [Washer](https://developer.home-connect.com/docs/washing-machine/supported_programs_and_options) * [Dryer](https://developer.home-connect.com/docs/dryer/supported_programs_and_options) * [Coffee Machine](https://developer.home-connect.com/docs/coffee-maker/supported_programs_and_options) * [Hood](https://developer.home-connect.com/docs/hood/supported_programs_and_options) * [Cleaning Robot](https://developer.home-connect.com/docs/cleaningrobot/supported_programs_and_options)  There are no programs available for fridges and hobs.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_program_with_http_info(haid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param Program body: description of the program to activate (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'body',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_program" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `start_program`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `start_program`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/active', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stop_program(self, haid, **kwargs):  # noqa: E501
        """Stop the program which is currently executed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stop_program(haid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str accept_language: Language for localized assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.stop_program_with_http_info(haid, **kwargs)  # noqa: E501

    def stop_program_with_http_info(self, haid, **kwargs):  # noqa: E501
        """Stop the program which is currently executed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stop_program_with_http_info(haid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str haid: ID of home appliance (required)
        :param str accept_language: Language for localized assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'haid',
            'accept_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stop_program" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'haid' is set
        if self.api_client.client_side_validation and ('haid' not in local_var_params or  # noqa: E501
                                                        local_var_params['haid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `haid` when calling `stop_program`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'haid' in local_var_params:
            path_params['haid'] = local_var_params['haid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in local_var_params:
            header_params['Accept-Language'] = local_var_params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.bsh.sdk.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['homeconnect_auth']  # noqa: E501

        return self.api_client.call_api(
            '/homeappliances/{haid}/programs/active', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
