# home-connect-sdk
This API provides access to home appliances enabled by Home Connect
(https://home-connect.com). Through the API programs can be started and
stopped, or home appliances configured and monitored. For instance, you can
start a cotton program on a washer and get a notification when the cycle is
complete.

To get started with this web client, visit https://developer.home-connect.com
and register an account. An application with a client ID for this API client
will be automatically generated for you.

In order to use this API in your own client, you need an OAuth 2 client
implementing the authorization code grant flow
(https://developer.home-connect.com/docs/authorization/flow).


More details can be found here: https://www.rfc-editor.org/rfc/rfc6749.txt

Authorization URL: https://api.home-connect.com/security/oauth/authorize

Token URL: https://api.home-connect.com/security/oauth/token


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/jeroenvdwaal/home-connect-sdk.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/jeroenvdwaal/home-connect-sdk.git`)

Then import the package:
```python
import home_connect_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import home_connect_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import home_connect_sdk
from home_connect_sdk.rest import ApiException
from pprint import pprint

configuration = home_connect_sdk.Configuration()
# Configure OAuth2 access token for authorization: homeconnect_auth
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# Defining host is optional and default to https://api.home-connect.com/api
configuration.host = "https://api.home-connect.com/api"

# Defining host is optional and default to https://api.home-connect.com/api
configuration.host = "https://api.home-connect.com/api"
# Enter a context with an instance of the API client
with home_connect_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = home_connect_sdk.CommandsApi(api_client)
    haid = 'haid_example' # str | ID of home appliance
accept_language = 'accept_language_example' # str | Language for localized assets (optional)

    try:
        # Get a list of supported commands of the home appliance
        api_instance.get_available_commands(haid, accept_language=accept_language)
    except ApiException as e:
        print("Exception when calling CommandsApi->get_available_commands: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://api.home-connect.com/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CommandsApi* | [**get_available_commands**](docs/CommandsApi.md#get_available_commands) | **GET** /homeappliances/{haid}/commands | Get a list of supported commands of the home appliance
*CommandsApi* | [**put_command**](docs/CommandsApi.md#put_command) | **PUT** /homeappliances/{haid}/commands/{commandkey} | Execute a specific command of the home appliance
*DefaultApi* | [**get_home_appliances**](docs/DefaultApi.md#get_home_appliances) | **GET** /homeappliances | Get all home appliances which are paired with the logged-in user account.
*DefaultApi* | [**get_specific_appliance**](docs/DefaultApi.md#get_specific_appliance) | **GET** /homeappliances/{haid} | Get a specfic home appliances which are paired with the logged-in user account.
*ImagesApi* | [**get_image**](docs/ImagesApi.md#get_image) | **GET** /homeappliances/{haid}/images/{imagekey} | Get a specific image
*ImagesApi* | [**get_images**](docs/ImagesApi.md#get_images) | **GET** /homeappliances/{haid}/images | Get a list of available images
*ProgramsApi* | [**get_active_program**](docs/ProgramsApi.md#get_active_program) | **GET** /homeappliances/{haid}/programs/active | Get program which is currently executed
*ProgramsApi* | [**get_active_program_option**](docs/ProgramsApi.md#get_active_program_option) | **GET** /homeappliances/{haid}/programs/active/options/{optionkey} | Get one specific option of the active program, e.g. the duration.
*ProgramsApi* | [**get_active_program_options**](docs/ProgramsApi.md#get_active_program_options) | **GET** /homeappliances/{haid}/programs/active/options | Get all options of the active program like temperature or duration.
*ProgramsApi* | [**get_all_programs**](docs/ProgramsApi.md#get_all_programs) | **GET** /homeappliances/{haid}/programs | Get all programs of a given home appliance
*ProgramsApi* | [**get_available_program**](docs/ProgramsApi.md#get_available_program) | **GET** /homeappliances/{haid}/programs/available/{programkey} | Get specific available program
*ProgramsApi* | [**get_available_programs**](docs/ProgramsApi.md#get_available_programs) | **GET** /homeappliances/{haid}/programs/available | Get all programs which are currently available on the given home appliance
*ProgramsApi* | [**get_selected_program**](docs/ProgramsApi.md#get_selected_program) | **GET** /homeappliances/{haid}/programs/selected | Get the program which is currently selected 
*ProgramsApi* | [**get_selected_program_option**](docs/ProgramsApi.md#get_selected_program_option) | **GET** /homeappliances/{haid}/programs/selected/options/{optionkey} | Get specific option of selected program
*ProgramsApi* | [**get_selected_program_options**](docs/ProgramsApi.md#get_selected_program_options) | **GET** /homeappliances/{haid}/programs/selected/options | Get all options of selected program
*ProgramsApi* | [**set_active_program_option**](docs/ProgramsApi.md#set_active_program_option) | **PUT** /homeappliances/{haid}/programs/active/options/{optionkey} | Set one specific option of the active program
*ProgramsApi* | [**set_active_program_options**](docs/ProgramsApi.md#set_active_program_options) | **PUT** /homeappliances/{haid}/programs/active/options | Set all options of the active program, e.g. to switch from preheating to the actual program options.
*ProgramsApi* | [**set_selected_program**](docs/ProgramsApi.md#set_selected_program) | **PUT** /homeappliances/{haid}/programs/selected | Select a program
*ProgramsApi* | [**set_selected_program_option**](docs/ProgramsApi.md#set_selected_program_option) | **PUT** /homeappliances/{haid}/programs/selected/options/{optionkey} | Set specific option of selected program
*ProgramsApi* | [**set_selected_program_options**](docs/ProgramsApi.md#set_selected_program_options) | **PUT** /homeappliances/{haid}/programs/selected/options | Set all options of selected program
*ProgramsApi* | [**start_program**](docs/ProgramsApi.md#start_program) | **PUT** /homeappliances/{haid}/programs/active | Start the given program
*ProgramsApi* | [**stop_program**](docs/ProgramsApi.md#stop_program) | **DELETE** /homeappliances/{haid}/programs/active | Stop the program which is currently executed
*SettingsApi* | [**get_setting**](docs/SettingsApi.md#get_setting) | **GET** /homeappliances/{haid}/settings/{settingkey} | Get a specific setting
*SettingsApi* | [**get_settings**](docs/SettingsApi.md#get_settings) | **GET** /homeappliances/{haid}/settings | Get a list of available settings
*SettingsApi* | [**set_setting**](docs/SettingsApi.md#set_setting) | **PUT** /homeappliances/{haid}/settings/{settingkey} | Set a specific setting
*StatusEventsApi* | [**get_all_events**](docs/StatusEventsApi.md#get_all_events) | **GET** /homeappliances/events | Get stream of events for all appliances - NOT WORKING WITH SWAGGER
*StatusEventsApi* | [**get_events**](docs/StatusEventsApi.md#get_events) | **GET** /homeappliances/{haid}/events | Get stream of events for one appliance - NOT WORKING WITH SWAGGER
*StatusEventsApi* | [**get_status**](docs/StatusEventsApi.md#get_status) | **GET** /homeappliances/{haid}/status | Get current status of home appliance
*StatusEventsApi* | [**get_status_value**](docs/StatusEventsApi.md#get_status_value) | **GET** /homeappliances/{haid}/status/{statuskey} | Get current status of home appliance


## Documentation For Models

 - [ActiveProgramNotSetError](docs/ActiveProgramNotSetError.md)
 - [ArrayOfAvailablePrograms](docs/ArrayOfAvailablePrograms.md)
 - [ArrayOfAvailableProgramsData](docs/ArrayOfAvailableProgramsData.md)
 - [ArrayOfAvailableProgramsDataConstraints](docs/ArrayOfAvailableProgramsDataConstraints.md)
 - [ArrayOfAvailableProgramsDataPrograms](docs/ArrayOfAvailableProgramsDataPrograms.md)
 - [ArrayOfEvents](docs/ArrayOfEvents.md)
 - [ArrayOfEventsItems](docs/ArrayOfEventsItems.md)
 - [ArrayOfHomeAppliances](docs/ArrayOfHomeAppliances.md)
 - [ArrayOfHomeAppliancesData](docs/ArrayOfHomeAppliancesData.md)
 - [ArrayOfHomeAppliancesDataHomeappliances](docs/ArrayOfHomeAppliancesDataHomeappliances.md)
 - [ArrayOfImages](docs/ArrayOfImages.md)
 - [ArrayOfImagesData](docs/ArrayOfImagesData.md)
 - [ArrayOfImagesDataImages](docs/ArrayOfImagesDataImages.md)
 - [ArrayOfOptions](docs/ArrayOfOptions.md)
 - [ArrayOfOptionsData](docs/ArrayOfOptionsData.md)
 - [ArrayOfPrograms](docs/ArrayOfPrograms.md)
 - [ArrayOfProgramsData](docs/ArrayOfProgramsData.md)
 - [ArrayOfProgramsDataConstraints](docs/ArrayOfProgramsDataConstraints.md)
 - [ArrayOfProgramsDataPrograms](docs/ArrayOfProgramsDataPrograms.md)
 - [ArrayOfSettings](docs/ArrayOfSettings.md)
 - [ArrayOfSettingsData](docs/ArrayOfSettingsData.md)
 - [ArrayOfSettingsDataSettings](docs/ArrayOfSettingsDataSettings.md)
 - [ArrayOfStatus](docs/ArrayOfStatus.md)
 - [ArrayOfStatusData](docs/ArrayOfStatusData.md)
 - [Command](docs/Command.md)
 - [CommandData](docs/CommandData.md)
 - [CommandDefinition](docs/CommandDefinition.md)
 - [CommandDefinitionData](docs/CommandDefinitionData.md)
 - [Conflict](docs/Conflict.md)
 - [ConflictError](docs/ConflictError.md)
 - [ForbiddenError](docs/ForbiddenError.md)
 - [GetSetting](docs/GetSetting.md)
 - [GetSettingData](docs/GetSettingData.md)
 - [GetSettingDataConstraints](docs/GetSettingDataConstraints.md)
 - [HomeAppliance](docs/HomeAppliance.md)
 - [HomeApplianceData](docs/HomeApplianceData.md)
 - [InteralServerError](docs/InteralServerError.md)
 - [NoProgramActiveError](docs/NoProgramActiveError.md)
 - [NoProgramSelectedError](docs/NoProgramSelectedError.md)
 - [NotAcceptableError](docs/NotAcceptableError.md)
 - [NotFoundError](docs/NotFoundError.md)
 - [Option](docs/Option.md)
 - [OptionData](docs/OptionData.md)
 - [Program](docs/Program.md)
 - [ProgramData](docs/ProgramData.md)
 - [ProgramDataOptions](docs/ProgramDataOptions.md)
 - [ProgramDefinition](docs/ProgramDefinition.md)
 - [ProgramDefinitionData](docs/ProgramDefinitionData.md)
 - [ProgramDefinitionDataConstraints](docs/ProgramDefinitionDataConstraints.md)
 - [ProgramDefinitionDataOptions](docs/ProgramDefinitionDataOptions.md)
 - [ProgramNotAvailableError](docs/ProgramNotAvailableError.md)
 - [PutSetting](docs/PutSetting.md)
 - [PutSettingData](docs/PutSettingData.md)
 - [PutSettingDataConstraints](docs/PutSettingDataConstraints.md)
 - [RequestTimeoutError](docs/RequestTimeoutError.md)
 - [SelectedProgramNotSetError](docs/SelectedProgramNotSetError.md)
 - [Status](docs/Status.md)
 - [StatusData](docs/StatusData.md)
 - [TooManyRequestsError](docs/TooManyRequestsError.md)
 - [UnauthorizedError](docs/UnauthorizedError.md)
 - [UnauthorizedErrorError](docs/UnauthorizedErrorError.md)
 - [UnsupportedMediaTypeError](docs/UnsupportedMediaTypeError.md)
 - [WrongOperationStateError](docs/WrongOperationStateError.md)


## Documentation For Authorization


## homeconnect_auth

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://api.home-connect.com/security/oauth/authorize
- **Scopes**: 
 - **IdentifyAppliance**: Grants right to identify a home appliance under /api/homeappliances
 - **Monitor**: Grants access to read resources under /api/homeappliances except images and settings
 - **Control**: Grants access to modify resources under under /api/homeappliances except images and settings
 - **Images**: Grants access to read resources under /api/homeappliances/{haid}/images
 - **Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings
 - **Oven-Monitor**: Grants access to read resources under /api/homeappliances except images and settings on ovens
 - **Oven-Control**: Grants access to modify resources under under /api/homeappliances except images and settings on ovens
 - **Oven-Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings on ovens
 - **Oven**: Grants access to read or modify all resources under /api/homeappliances on ovens
 - **Dishwasher-Monitor**: Grants access to read resources under /api/homeappliances except images and settings on dishwashers
 - **Dishwasher-Control**: Grants access to modify resources under under /api/homeappliances except images and settings on dishwashers
 - **Dishwasher-Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings on dishwashers
 - **Dishwasher**: Grants access to read or modify all resources under /api/homeappliances on dishwashers
 - **Washer-Monitor**: Grants access to read resources under /api/homeappliances except images and settings on washers
 - **Washer-Control**: Grants access to modify resources under under /api/homeappliances except images and settings on washers
 - **Washer-Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings on washers
 - **Washer**: Grants access to read or modify all resources under /api/homeappliances on washers
 - **Dryer-Monitor**: Grants access to read resources under /api/homeappliances except images and settings on dryers
 - **Dryer-Control**: Grants access to modify resources under under /api/homeappliances except images and settings on dryers
 - **Dryer-Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings on dryers
 - **Dryer**: Grants access to read or modify all resources under /api/homeappliances on dryers
 - **WasherDryer-Monitor**: Grants access to read resources under /api/homeappliances except images and settings on washerdryers
 - **WasherDryer-Control**: Grants access to modify resources under under /api/homeappliances except images and settings on washerdryers
 - **WasherDryer-Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings on washerdryers
 - **WasherDryer**: Grants access to read or modify all resources under /api/homeappliances on washerdryers
 - **FridgeFreezer-Monitor**: Grants access to read resources under /api/homeappliances except images and settings on fridgefreezers
 - **FridgeFreezer-Control**: Grants access to modify resources under /api/homeappliances except images and settings on fridgefreezers
 - **FridgeFreezer-Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings on fridgefreezers
 - **FridgeFreezer-Images**: Grants access to read resources under /api/homeappliances/{haid}/images on fridgefreezers
 - **FridgeFreezer**: Grants access to read or modify all resources under /api/homeappliances on fridgefreezers
 - **CoffeeMaker-Monitor**: Grants access to read resources under /api/homeappliances except images and settings on coffee makers
 - **CoffeeMaker-Control**: Grants access to modify resources under under /api/homeappliances except images and settings on coffee makers
 - **CoffeeMaker-Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings on coffee makers
 - **CoffeeMaker**: Grants access to read or modify all resources under /api/homeappliances on coffee makers
 - **Hob-Monitor**: Grants access to read resources under /api/homeappliances except images and settings on hobs
 - **Hob-Control**: Grants access to modify resources under under /api/homeappliances except images and settings on hobs
 - **Hob-Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings on hobs
 - **Hob**: Grants access to read or modify all resources under /api/homeappliances on hobs
 - **Hood-Monitor**: Grants access to read resources under /api/homeappliances except images and settings on hoods
 - **Hood-Control**: Grants access to modify resources under under /api/homeappliances except images and settings on hoods
 - **Hood-Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings on hoods
 - **Hood**: Grants access to read or modify all resources under /api/homeappliances on hoods
 - **CleaningRobot-Monitor**: Grants access to read resources under /api/homeappliances except images and settings on cleaning robots
 - **CleaningRobot-Control**: Grants access to modify resources under under /api/homeappliances except images and settings on cleaning robots
 - **CleaningRobot-Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings on cleaning robots
 - **CleaningRobot**: Grants access to read or modify all resources under /api/homeappliances on cleaning robots
 - **Refigerator-Monitor**: Grants access to read resources under /api/homeappliances except images and settings on refrigerators
 - **Refigerator-Control**: Grants access to modify resources under under /api/homeappliances except images and settings on refrigerators
 - **Refigerator-Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings on refrigerators
 - **Refigerator**: Grants access to read or modify all resources under /api/homeappliances on refrigerators
 - **Freezer-Monitor**: Grants access to read resources under /api/homeappliances except images and settings on freezers
 - **Freezer-Control**: Grants access to modify resources under under /api/homeappliances except images and settings on freezers
 - **Freezer-Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings on freezers
 - **Freezer**: Grants access to read or modify all resources under /api/homeappliances on freezers
 - **WineCooler-Monitor**: Grants access to read resources under /api/homeappliances except images and settings on wine coolers
 - **WineCooler-Control**: Grants access to modify resources under under /api/homeappliances except images and settings on wine coolers
 - **WineCooler-Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings on wine coolers
 - **WineCooler**: Grants access to read or modify all resources under /api/homeappliances on wine coolers
 - **CookProcessor-Monitor**: Grants access to read resources under /api/homeappliances except images and settings on cookprocessors
 - **CookProcessor-Control**: Grants access to modify resources under under /api/homeappliances except images and settings on cookprocessors
 - **CookProcessor-Settings**: Grants access to read and modify resources under /api/homeappliances/{haid}/settings on cookprocessors
 - **CookProcessor**: Grants access to read or modify all resources under /api/homeappliances on cookprocessors


## Author




