# Getting Started

## System Prerequisites

Surfactant requires Python 3.8 or newer. Tests are regularly run on Linux, macOS,
and Windows, though it should also work on other operating systems such as FreeBSD.

## Installation

### For Users:

For ease of use, we recommend using [pipx](https://github.com/pypa/pipx) since it transparently handles creating and using Python virtual environments, which helps avoid dependency conflicts with other installed Python apps. Install `pipx` by following [their installation instructions](https://github.com/pypa/pipx#install-pipx).

1. Install Surfactant using `pipx install` (with python >= 3.8)

```bash
pipx install surfactant
```

> Note: Mach-O file support requires installing Surfactant with the `macho` optional dependencies (e.g. `pipx install surfactant[macho]`).

2. Install plugins using `pipx inject surfactant`. As an example, this is how the fuzzy hashing plugin could be installed from a git repository (PyPI package names, local source directories, or wheel files can also be used).

```bash
pipx inject surfactant git+https://github.com/LLNL/Surfactant#subdirectory=plugins/fuzzyhashes
```

If for some reason manually managing virtual environments is desired, the following steps can be used instead:

1. Create a virtual environment with python >= 3.8 and activate it [Optional, but highly recommended over a global install]

```bash
python -m venv cytrics_venv
source cytrics_venv/bin/activate
```

2. Install Surfactant with `pip install`

```bash
pip install surfactant
```

3. Install plugins using `pip install`. As an example, this is how the fuzzy hashing plugin could be installed from a git repository (PyPI package names, local source directories, or wheel files can also be used).

```bash
pip install git+https://github.com/LLNL/Surfactant#subdirectory=plugins/fuzzyhashes
```

### For Developers:

1. Create a virtual environment with python >= 3.8 [Optional, but recommended]

```bash
python -m venv cytrics_venv
source cytrics_venv/bin/activate
```

2. Clone sbom-surfactant

```bash
git clone git@github.com:LLNL/Surfactant.git
```

3. Create an editable surfactant install (changes to code will take effect immediately):

```bash
pip install -e .
```

To install optional dependencies required for running pytest and pre-commit:

```bash
pip install -e ".[test,dev]"
```

`pip install` with the `-e` or `--editable` option can also be used to install Surfactant plugins for development.

## Understanding the SBOM Output

The following is a brief overview of the default SBOM file output format (which follows the CyTRICS schema). It is
not an exhaustive guide to the SBOM format. When the schema is made publicly available a link will be included here.

### Software

This section contains a list of entries relating to each piece of software found in the sample. Metadata including file size, vendor, version, etc are included in this section along with a uuid to uniquely identify the software entry.

### Relationships

This section contains information on how each of the software entries in the previous section are linked.

**Uses**: this relationship type means that x software uses y software i.e. y is a helper module to x\
**Contains**: this relationship type means that x software contains y software (often x software is an installer or archive such as a zip file)

### Star Relationships

This section contains information on how analysis data or observation entries are related/linked to software (or hardware) entries.

### Observations

This section contains observations, typically related to CVEs that impact a piece of software.

### Analysis Data

This section is for listing files that are output by plugins/analysis tools.

### Hardware

This section contains information on hardware, ranging from a fairly high-level down to individual components on a PCB.
Surfactant does not currently populate this section, it is either filled in manually or using other tools that are aimed
at analyzing based on pictures of circuit boards.

### System

This section contains information on the overall system that software and hardware entries are a part of. Typically
it will be manually added to an SBOM that has been generated by Surfactant, though the merge command can also be
given an option to generate a system entry.
