"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateTestApi = void 0;
const lambda = require("aws-cdk-lib/aws-lambda");
const api = require("aws-cdk-lib/aws-apigateway");
const core_1 = require("@aws-solutions-constructs/core");
function CreateTestApi(stack, id) {
    const lamdaFunction = new lambda.Function(stack, `${id}Function`, {
        code: lambda.Code.fromAsset(`${__dirname}/lambda`),
        runtime: lambda.Runtime.NODEJS_14_X,
        handler: ".handler",
    });
    core_1.addCfnSuppressRules(lamdaFunction, [{ id: "W58", reason: "Test Resource" }]);
    core_1.addCfnSuppressRules(lamdaFunction, [{ id: "W89", reason: "Test Resource" }]);
    core_1.addCfnSuppressRules(lamdaFunction, [{ id: "W92", reason: "Test Resource" }]);
    const restApi = new api.LambdaRestApi(stack, `${id}Api`, {
        handler: lamdaFunction,
    });
    const newDeployment = restApi.latestDeployment;
    if (newDeployment) {
        core_1.addCfnSuppressRules(newDeployment, [
            { id: "W68", reason: "Test Resource" },
        ]);
    }
    const newMethod = restApi.methods[0];
    core_1.addCfnSuppressRules(newMethod, [{ id: "W59", reason: "Test Resource" }]);
    const newMethodTwo = restApi.methods[1];
    core_1.addCfnSuppressRules(newMethodTwo, [{ id: "W59", reason: "Test Resource" }]);
    const newStage = restApi.deploymentStage;
    core_1.addCfnSuppressRules(newStage, [{ id: "W64", reason: "Test Resource" }]);
    core_1.addCfnSuppressRules(newStage, [{ id: "W69", reason: "Test Resource" }]);
    return restApi;
}
exports.CreateTestApi = CreateTestApi;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC1oZWxwZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXN0LWhlbHBlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7Ozs7Ozs7Ozs7O0dBV0c7OztBQUdILGlEQUFpRDtBQUNqRCxrREFBa0Q7QUFDbEQseURBQXFFO0FBRXJFLFNBQWdCLGFBQWEsQ0FBQyxLQUFZLEVBQUUsRUFBVTtJQUNwRCxNQUFNLGFBQWEsR0FBRyxJQUFJLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLEdBQUcsRUFBRSxVQUFVLEVBQUU7UUFDaEUsSUFBSSxFQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQUcsU0FBUyxTQUFTLENBQUM7UUFDbEQsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVztRQUNuQyxPQUFPLEVBQUUsVUFBVTtLQUNwQixDQUFDLENBQUM7SUFDSCwwQkFBbUIsQ0FBQyxhQUFhLEVBQUUsQ0FBQyxFQUFFLEVBQUUsRUFBRSxLQUFLLEVBQUUsTUFBTSxFQUFFLGVBQWUsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUM3RSwwQkFBbUIsQ0FBQyxhQUFhLEVBQUUsQ0FBQyxFQUFFLEVBQUUsRUFBRSxLQUFLLEVBQUUsTUFBTSxFQUFFLGVBQWUsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUM3RSwwQkFBbUIsQ0FBQyxhQUFhLEVBQUUsQ0FBQyxFQUFFLEVBQUUsRUFBRSxLQUFLLEVBQUUsTUFBTSxFQUFFLGVBQWUsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUU3RSxNQUFNLE9BQU8sR0FBRyxJQUFJLEdBQUcsQ0FBQyxhQUFhLENBQUMsS0FBSyxFQUFFLEdBQUcsRUFBRSxLQUFLLEVBQUU7UUFDdkQsT0FBTyxFQUFFLGFBQWE7S0FDdkIsQ0FBQyxDQUFDO0lBRUgsTUFBTSxhQUFhLEdBQUcsT0FBTyxDQUFDLGdCQUFnQixDQUFDO0lBQy9DLElBQUksYUFBYSxFQUFFO1FBQ2pCLDBCQUFtQixDQUFDLGFBQWEsRUFBRTtZQUNqQyxFQUFFLEVBQUUsRUFBRSxLQUFLLEVBQUUsTUFBTSxFQUFFLGVBQWUsRUFBRTtTQUN2QyxDQUFDLENBQUM7S0FDSjtJQUVELE1BQU0sU0FBUyxHQUFHLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDckMsMEJBQW1CLENBQUMsU0FBUyxFQUFFLENBQUMsRUFBRSxFQUFFLEVBQUUsS0FBSyxFQUFFLE1BQU0sRUFBRSxlQUFlLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDekUsTUFBTSxZQUFZLEdBQUcsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN4QywwQkFBbUIsQ0FBQyxZQUFZLEVBQUUsQ0FBQyxFQUFFLEVBQUUsRUFBRSxLQUFLLEVBQUUsTUFBTSxFQUFFLGVBQWUsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUU1RSxNQUFNLFFBQVEsR0FBRyxPQUFPLENBQUMsZUFBZSxDQUFDO0lBQ3pDLDBCQUFtQixDQUFDLFFBQVEsRUFBRSxDQUFDLEVBQUUsRUFBRSxFQUFFLEtBQUssRUFBRSxNQUFNLEVBQUUsZUFBZSxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBQ3hFLDBCQUFtQixDQUFDLFFBQVEsRUFBRSxDQUFDLEVBQUUsRUFBRSxFQUFFLEtBQUssRUFBRSxNQUFNLEVBQUUsZUFBZSxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBRXhFLE9BQU8sT0FBTyxDQUFDO0FBQ2pCLENBQUM7QUEvQkQsc0NBK0JDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiAgQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0IHsgU3RhY2sgfSBmcm9tIFwiYXdzLWNkay1saWJcIjtcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWxhbWJkYVwiO1xuaW1wb3J0ICogYXMgYXBpIGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtYXBpZ2F0ZXdheVwiO1xuaW1wb3J0IHsgYWRkQ2ZuU3VwcHJlc3NSdWxlcyB9IGZyb20gXCJAYXdzLXNvbHV0aW9ucy1jb25zdHJ1Y3RzL2NvcmVcIjtcblxuZXhwb3J0IGZ1bmN0aW9uIENyZWF0ZVRlc3RBcGkoc3RhY2s6IFN0YWNrLCBpZDogc3RyaW5nKTogYXBpLkxhbWJkYVJlc3RBcGkge1xuICBjb25zdCBsYW1kYUZ1bmN0aW9uID0gbmV3IGxhbWJkYS5GdW5jdGlvbihzdGFjaywgYCR7aWR9RnVuY3Rpb25gLCB7XG4gICAgY29kZTogbGFtYmRhLkNvZGUuZnJvbUFzc2V0KGAke19fZGlybmFtZX0vbGFtYmRhYCksXG4gICAgcnVudGltZTogbGFtYmRhLlJ1bnRpbWUuTk9ERUpTXzE0X1gsXG4gICAgaGFuZGxlcjogXCIuaGFuZGxlclwiLFxuICB9KTtcbiAgYWRkQ2ZuU3VwcHJlc3NSdWxlcyhsYW1kYUZ1bmN0aW9uLCBbeyBpZDogXCJXNThcIiwgcmVhc29uOiBcIlRlc3QgUmVzb3VyY2VcIiB9XSk7XG4gIGFkZENmblN1cHByZXNzUnVsZXMobGFtZGFGdW5jdGlvbiwgW3sgaWQ6IFwiVzg5XCIsIHJlYXNvbjogXCJUZXN0IFJlc291cmNlXCIgfV0pO1xuICBhZGRDZm5TdXBwcmVzc1J1bGVzKGxhbWRhRnVuY3Rpb24sIFt7IGlkOiBcIlc5MlwiLCByZWFzb246IFwiVGVzdCBSZXNvdXJjZVwiIH1dKTtcblxuICBjb25zdCByZXN0QXBpID0gbmV3IGFwaS5MYW1iZGFSZXN0QXBpKHN0YWNrLCBgJHtpZH1BcGlgLCB7XG4gICAgaGFuZGxlcjogbGFtZGFGdW5jdGlvbixcbiAgfSk7XG5cbiAgY29uc3QgbmV3RGVwbG95bWVudCA9IHJlc3RBcGkubGF0ZXN0RGVwbG95bWVudDtcbiAgaWYgKG5ld0RlcGxveW1lbnQpIHtcbiAgICBhZGRDZm5TdXBwcmVzc1J1bGVzKG5ld0RlcGxveW1lbnQsIFtcbiAgICAgIHsgaWQ6IFwiVzY4XCIsIHJlYXNvbjogXCJUZXN0IFJlc291cmNlXCIgfSxcbiAgICBdKTtcbiAgfVxuXG4gIGNvbnN0IG5ld01ldGhvZCA9IHJlc3RBcGkubWV0aG9kc1swXTtcbiAgYWRkQ2ZuU3VwcHJlc3NSdWxlcyhuZXdNZXRob2QsIFt7IGlkOiBcIlc1OVwiLCByZWFzb246IFwiVGVzdCBSZXNvdXJjZVwiIH1dKTtcbiAgY29uc3QgbmV3TWV0aG9kVHdvID0gcmVzdEFwaS5tZXRob2RzWzFdO1xuICBhZGRDZm5TdXBwcmVzc1J1bGVzKG5ld01ldGhvZFR3bywgW3sgaWQ6IFwiVzU5XCIsIHJlYXNvbjogXCJUZXN0IFJlc291cmNlXCIgfV0pO1xuXG4gIGNvbnN0IG5ld1N0YWdlID0gcmVzdEFwaS5kZXBsb3ltZW50U3RhZ2U7XG4gIGFkZENmblN1cHByZXNzUnVsZXMobmV3U3RhZ2UsIFt7IGlkOiBcIlc2NFwiLCByZWFzb246IFwiVGVzdCBSZXNvdXJjZVwiIH1dKTtcbiAgYWRkQ2ZuU3VwcHJlc3NSdWxlcyhuZXdTdGFnZSwgW3sgaWQ6IFwiVzY5XCIsIHJlYXNvbjogXCJUZXN0IFJlc291cmNlXCIgfV0pO1xuXG4gIHJldHVybiByZXN0QXBpO1xufVxuIl19