"use strict";
// Integration test to deploy some resources, create an alarm on it and create a dashboard.
//
// Because literally every other library is going to depend on @aws-cdk/aws-cloudwatch, we drop down
// to the very lowest level to create CloudFormation resources by hand, without even generated
// library support.
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const cloudwatch = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-cloudwatch-alarms');
const queue = new cdk.CfnResource(stack, 'queue', { type: 'AWS::SQS::Queue' });
const metric = new cloudwatch.Metric({
    namespace: 'AWS/SQS',
    metricName: 'ApproximateNumberOfMessagesVisible',
    dimensions: { QueueName: queue.getAtt('QueueName') },
});
const alarm = metric.createAlarm(stack, 'Alarm', {
    threshold: 100,
    evaluationPeriods: 3,
    datapointsToAlarm: 2,
});
const dashboard = new cloudwatch.Dashboard(stack, 'Dash', {
    dashboardName: 'MyCustomDashboardName',
    start: '-9H',
    end: '2018-12-17T06:00:00.000Z',
    periodOverride: cloudwatch.PeriodOverride.INHERIT,
});
dashboard.addWidgets(new cloudwatch.TextWidget({ markdown: '# This is my dashboard' }), new cloudwatch.TextWidget({ markdown: 'you like?' }));
dashboard.addWidgets(new cloudwatch.AlarmWidget({
    title: 'Messages in queue',
    alarm,
}));
dashboard.addWidgets(new cloudwatch.GraphWidget({
    title: 'More messages in queue with alarm annotation',
    left: [metric],
    leftAnnotations: [alarm.toAnnotation()],
}));
dashboard.addWidgets(new cloudwatch.SingleValueWidget({
    title: 'Current messages in queue',
    metrics: [metric],
}));
dashboard.addWidgets(new cloudwatch.LogQueryWidget({
    title: 'Errors in my log group',
    logGroupNames: ['my-log-group'],
    queryString: `fields @message
                | filter @message like /Error/`,
}));
dashboard.addWidgets(new cloudwatch.LogQueryWidget({
    title: 'Errors in my log group - bar',
    view: cloudwatch.LogQueryVisualizationType.BAR,
    logGroupNames: ['my-log-group'],
    queryString: `fields @message
                | filter @message like /Error/`,
}));
dashboard.addWidgets(new cloudwatch.LogQueryWidget({
    title: 'Errors in my log group - line',
    view: cloudwatch.LogQueryVisualizationType.LINE,
    logGroupNames: ['my-log-group'],
    queryString: `fields @message
                | filter @message like /Error/`,
}));
dashboard.addWidgets(new cloudwatch.LogQueryWidget({
    title: 'Errors in my log group - stacked',
    view: cloudwatch.LogQueryVisualizationType.STACKEDAREA,
    logGroupNames: ['my-log-group'],
    queryString: `fields @message
                | filter @message like /Error/`,
}));
dashboard.addWidgets(new cloudwatch.LogQueryWidget({
    title: 'Errors in my log group - pie',
    view: cloudwatch.LogQueryVisualizationType.PIE,
    logGroupNames: ['my-log-group'],
    queryString: `fields @message
                | filter @message like /Error/`,
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,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