# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .style_guide_status import StyleGuideStatus


class StyleGuideResponse(UniversalBaseModel):
    id: str
    name: str = pydantic.Field()
    """
    The name of the style guide.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    The UTC date and time the style guide was created.
    """

    created_by: str = pydantic.Field()
    """
    The ID of the user who created the style guide.
    """

    status: StyleGuideStatus = pydantic.Field()
    """
    The status of the submitted style guide.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The UTC datetime that the style guide was last updated. If null, the style guide has never been updated.
    """

    updated_by: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the user who last updated the style guide. If null, the style guide has never been updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
