# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .issue_category import IssueCategory
from .subcategory import Subcategory


class Issue(UniversalBaseModel):
    original: str = pydantic.Field()
    """
    The original text
    """

    char_index: int = pydantic.Field()
    """
    The start index of the change
    """

    subcategory: Subcategory = pydantic.Field()
    """
    The sub-category of the change
    """

    category: typing.Optional[IssueCategory] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
