# This file was auto-generated by Fern from our API Definition.

import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.dialects import Dialects
from ..types.suggestion_response import SuggestionResponse
from ..types.tones import Tones
from ..types.workflow_response import WorkflowResponse
from .raw_client import AsyncRawStyleSuggestionsClient, RawStyleSuggestionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class StyleSuggestionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawStyleSuggestionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawStyleSuggestionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawStyleSuggestionsClient
        """
        return self._raw_client

    def create_style_suggestion(
        self,
        *,
        file_upload: core.File,
        dialect: Dialects,
        tone: Tones,
        style_guide: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowResponse:
        """
        Start a style and brand suggestion workflow. Returns a workflow ID to use for polling results.

        Parameters
        ----------
        file_upload : core.File
            See core.File for more documentation

        dialect : Dialects
            The language variant you'd like us to use for analysis. Choose from American English, British English, or other supported dialects.

        tone : Tones
            The tone variation you're aiming for. Options include formal, academic, casual, and other tone variations to match your content goals.

        style_guide : str
            The style guide to follow for your content. You can use a style guide ID or choose from built-in options: `ap`, `chicago`, or `microsoft`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowResponse
            Check run started successfully.

        Examples
        --------
        from acrolinx import Acrolinx

        client = Acrolinx(
            token="YOUR_TOKEN",
        )
        client.style_suggestions.create_style_suggestion(
            dialect="american_english",
            tone="academic",
            style_guide="style_guide",
        )
        """
        _response = self._raw_client.create_style_suggestion(
            file_upload=file_upload,
            dialect=dialect,
            tone=tone,
            style_guide=style_guide,
            request_options=request_options,
        )
        return _response.data

    def get_style_suggestion(
        self, workflow_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuggestionResponse:
        """
        Retrieve the results of a style and brand suggestion workflow. Returns `running` or `complete` status.

        Parameters
        ----------
        workflow_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuggestionResponse
            The suggestion run results.

        Examples
        --------
        from acrolinx import Acrolinx

        client = Acrolinx(
            token="YOUR_TOKEN",
        )
        client.style_suggestions.get_style_suggestion(
            workflow_id="workflow_id",
        )
        """
        _response = self._raw_client.get_style_suggestion(workflow_id, request_options=request_options)
        return _response.data


class AsyncStyleSuggestionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawStyleSuggestionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawStyleSuggestionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawStyleSuggestionsClient
        """
        return self._raw_client

    async def create_style_suggestion(
        self,
        *,
        file_upload: core.File,
        dialect: Dialects,
        tone: Tones,
        style_guide: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowResponse:
        """
        Start a style and brand suggestion workflow. Returns a workflow ID to use for polling results.

        Parameters
        ----------
        file_upload : core.File
            See core.File for more documentation

        dialect : Dialects
            The language variant you'd like us to use for analysis. Choose from American English, British English, or other supported dialects.

        tone : Tones
            The tone variation you're aiming for. Options include formal, academic, casual, and other tone variations to match your content goals.

        style_guide : str
            The style guide to follow for your content. You can use a style guide ID or choose from built-in options: `ap`, `chicago`, or `microsoft`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowResponse
            Check run started successfully.

        Examples
        --------
        import asyncio

        from acrolinx import AsyncAcrolinx

        client = AsyncAcrolinx(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.style_suggestions.create_style_suggestion(
                dialect="american_english",
                tone="academic",
                style_guide="style_guide",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_style_suggestion(
            file_upload=file_upload,
            dialect=dialect,
            tone=tone,
            style_guide=style_guide,
            request_options=request_options,
        )
        return _response.data

    async def get_style_suggestion(
        self, workflow_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuggestionResponse:
        """
        Retrieve the results of a style and brand suggestion workflow. Returns `running` or `complete` status.

        Parameters
        ----------
        workflow_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuggestionResponse
            The suggestion run results.

        Examples
        --------
        import asyncio

        from acrolinx import AsyncAcrolinx

        client = AsyncAcrolinx(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.style_suggestions.get_style_suggestion(
                workflow_id="workflow_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_style_suggestion(workflow_id, request_options=request_options)
        return _response.data
