# This file was auto-generated by Fern from our API Definition.

import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.dialects import Dialects
from ..types.style_check_response import StyleCheckResponse
from ..types.tones import Tones
from ..types.workflow_response import WorkflowResponse
from .raw_client import AsyncRawStyleRewritesClient, RawStyleRewritesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class StyleRewritesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawStyleRewritesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawStyleRewritesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawStyleRewritesClient
        """
        return self._raw_client

    def create_style_rewrite(
        self,
        *,
        file_upload: core.File,
        dialect: Dialects,
        tone: Tones,
        style_guide: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowResponse:
        """
        Start a style and brand rewrite workflow. Returns a workflow ID to use for polling results.

        Parameters
        ----------
        file_upload : core.File
            See core.File for more documentation

        dialect : Dialects
            The language variant you'd like us to use for analysis. Choose from American English, British English, or other supported dialects.

        tone : Tones
            The tone variation you're aiming for. Options include formal, academic, casual, and other tone variations to match your content goals.

        style_guide : str
            The style guide to follow for your content. You can use a style guide ID or choose from built-in options: `ap`, `chicago`, or `microsoft`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowResponse
            Check run started successfully.

        Examples
        --------
        from acrolinx import Acrolinx

        client = Acrolinx(
            token="YOUR_TOKEN",
        )
        client.style_rewrites.create_style_rewrite(
            dialect="american_english",
            tone="academic",
            style_guide="style_guide",
        )
        """
        _response = self._raw_client.create_style_rewrite(
            file_upload=file_upload,
            dialect=dialect,
            tone=tone,
            style_guide=style_guide,
            request_options=request_options,
        )
        return _response.data

    def get_style_rewrite(
        self, workflow_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> StyleCheckResponse:
        """
        Retrieve the results of a rewrite workflow. Returns `running` or `complete` status.

        Parameters
        ----------
        workflow_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StyleCheckResponse
            The rewrite run results.

        Examples
        --------
        from acrolinx import Acrolinx

        client = Acrolinx(
            token="YOUR_TOKEN",
        )
        client.style_rewrites.get_style_rewrite(
            workflow_id="workflow_id",
        )
        """
        _response = self._raw_client.get_style_rewrite(workflow_id, request_options=request_options)
        return _response.data


class AsyncStyleRewritesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawStyleRewritesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawStyleRewritesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawStyleRewritesClient
        """
        return self._raw_client

    async def create_style_rewrite(
        self,
        *,
        file_upload: core.File,
        dialect: Dialects,
        tone: Tones,
        style_guide: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowResponse:
        """
        Start a style and brand rewrite workflow. Returns a workflow ID to use for polling results.

        Parameters
        ----------
        file_upload : core.File
            See core.File for more documentation

        dialect : Dialects
            The language variant you'd like us to use for analysis. Choose from American English, British English, or other supported dialects.

        tone : Tones
            The tone variation you're aiming for. Options include formal, academic, casual, and other tone variations to match your content goals.

        style_guide : str
            The style guide to follow for your content. You can use a style guide ID or choose from built-in options: `ap`, `chicago`, or `microsoft`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowResponse
            Check run started successfully.

        Examples
        --------
        import asyncio

        from acrolinx import AsyncAcrolinx

        client = AsyncAcrolinx(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.style_rewrites.create_style_rewrite(
                dialect="american_english",
                tone="academic",
                style_guide="style_guide",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_style_rewrite(
            file_upload=file_upload,
            dialect=dialect,
            tone=tone,
            style_guide=style_guide,
            request_options=request_options,
        )
        return _response.data

    async def get_style_rewrite(
        self, workflow_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> StyleCheckResponse:
        """
        Retrieve the results of a rewrite workflow. Returns `running` or `complete` status.

        Parameters
        ----------
        workflow_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StyleCheckResponse
            The rewrite run results.

        Examples
        --------
        import asyncio

        from acrolinx import AsyncAcrolinx

        client = AsyncAcrolinx(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.style_rewrites.get_style_rewrite(
                workflow_id="workflow_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_style_rewrite(workflow_id, request_options=request_options)
        return _response.data
