# This file was auto-generated by Fern from our API Definition.

import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.style_guide_response import StyleGuideResponse
from .raw_client import AsyncRawStyleGuidesClient, RawStyleGuidesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class StyleGuidesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawStyleGuidesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawStyleGuidesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawStyleGuidesClient
        """
        return self._raw_client

    def list_style_guides(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[StyleGuideResponse]:
        """
        Retrieve all style guides associated with your organization.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[StyleGuideResponse]
            Successful Response

        Examples
        --------
        from acrolinx import Acrolinx

        client = Acrolinx(
            token="YOUR_TOKEN",
        )
        client.style_guides.list_style_guides()
        """
        _response = self._raw_client.list_style_guides(request_options=request_options)
        return _response.data

    def create_style_guide(
        self,
        *,
        file_upload: core.File,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StyleGuideResponse:
        """
        Create a new style guide that can be used in checks, suggestions, and rewrites.

        Parameters
        ----------
        file_upload : core.File
            See core.File for more documentation

        name : typing.Optional[str]
            A friendly name for your style guide to help you identify it later. If left empty, we'll generate one for you.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StyleGuideResponse
            Successful Response

        Examples
        --------
        from acrolinx import Acrolinx

        client = Acrolinx(
            token="YOUR_TOKEN",
        )
        client.style_guides.create_style_guide()
        """
        _response = self._raw_client.create_style_guide(
            file_upload=file_upload, name=name, request_options=request_options
        )
        return _response.data

    def get_style_guide(
        self, style_guide_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> StyleGuideResponse:
        """
        Retrieve a specific style guide by ID, including its metadata such as `name` and `status`.

        Parameters
        ----------
        style_guide_id : str
            The ID of the style guide.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StyleGuideResponse
            Successful Response

        Examples
        --------
        from acrolinx import Acrolinx

        client = Acrolinx(
            token="YOUR_TOKEN",
        )
        client.style_guides.get_style_guide(
            style_guide_id="style_guide_id",
        )
        """
        _response = self._raw_client.get_style_guide(style_guide_id, request_options=request_options)
        return _response.data

    def delete_style_guide(
        self, style_guide_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete a style guide by ID.

        Parameters
        ----------
        style_guide_id : str
            The ID of the style guide.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from acrolinx import Acrolinx

        client = Acrolinx(
            token="YOUR_TOKEN",
        )
        client.style_guides.delete_style_guide(
            style_guide_id="style_guide_id",
        )
        """
        _response = self._raw_client.delete_style_guide(style_guide_id, request_options=request_options)
        return _response.data

    def update_style_guide(
        self, style_guide_id: str, *, name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> StyleGuideResponse:
        """
        Update the name of an existing style guide.

        Parameters
        ----------
        style_guide_id : str
            The ID of the style guide.

        name : str
            The name of the style guide.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StyleGuideResponse
            Successful Response

        Examples
        --------
        from acrolinx import Acrolinx

        client = Acrolinx(
            token="YOUR_TOKEN",
        )
        client.style_guides.update_style_guide(
            style_guide_id="style_guide_id",
            name="name",
        )
        """
        _response = self._raw_client.update_style_guide(style_guide_id, name=name, request_options=request_options)
        return _response.data


class AsyncStyleGuidesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawStyleGuidesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawStyleGuidesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawStyleGuidesClient
        """
        return self._raw_client

    async def list_style_guides(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[StyleGuideResponse]:
        """
        Retrieve all style guides associated with your organization.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[StyleGuideResponse]
            Successful Response

        Examples
        --------
        import asyncio

        from acrolinx import AsyncAcrolinx

        client = AsyncAcrolinx(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.style_guides.list_style_guides()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_style_guides(request_options=request_options)
        return _response.data

    async def create_style_guide(
        self,
        *,
        file_upload: core.File,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StyleGuideResponse:
        """
        Create a new style guide that can be used in checks, suggestions, and rewrites.

        Parameters
        ----------
        file_upload : core.File
            See core.File for more documentation

        name : typing.Optional[str]
            A friendly name for your style guide to help you identify it later. If left empty, we'll generate one for you.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StyleGuideResponse
            Successful Response

        Examples
        --------
        import asyncio

        from acrolinx import AsyncAcrolinx

        client = AsyncAcrolinx(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.style_guides.create_style_guide()


        asyncio.run(main())
        """
        _response = await self._raw_client.create_style_guide(
            file_upload=file_upload, name=name, request_options=request_options
        )
        return _response.data

    async def get_style_guide(
        self, style_guide_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> StyleGuideResponse:
        """
        Retrieve a specific style guide by ID, including its metadata such as `name` and `status`.

        Parameters
        ----------
        style_guide_id : str
            The ID of the style guide.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StyleGuideResponse
            Successful Response

        Examples
        --------
        import asyncio

        from acrolinx import AsyncAcrolinx

        client = AsyncAcrolinx(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.style_guides.get_style_guide(
                style_guide_id="style_guide_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_style_guide(style_guide_id, request_options=request_options)
        return _response.data

    async def delete_style_guide(
        self, style_guide_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete a style guide by ID.

        Parameters
        ----------
        style_guide_id : str
            The ID of the style guide.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from acrolinx import AsyncAcrolinx

        client = AsyncAcrolinx(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.style_guides.delete_style_guide(
                style_guide_id="style_guide_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_style_guide(style_guide_id, request_options=request_options)
        return _response.data

    async def update_style_guide(
        self, style_guide_id: str, *, name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> StyleGuideResponse:
        """
        Update the name of an existing style guide.

        Parameters
        ----------
        style_guide_id : str
            The ID of the style guide.

        name : str
            The name of the style guide.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StyleGuideResponse
            Successful Response

        Examples
        --------
        import asyncio

        from acrolinx import AsyncAcrolinx

        client = AsyncAcrolinx(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.style_guides.update_style_guide(
                style_guide_id="style_guide_id",
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_style_guide(
            style_guide_id, name=name, request_options=request_options
        )
        return _response.data
