# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/08_visualize_cnn_interpreter.ipynb (unless otherwise specified).

__all__ = ['show_heatmap', 'create_batch', 'GuidedBackprop', 'generate_cam', 'CamImage', 'get_at', 'show_at',
           'show_cam_batch', 'BaseInterpreter', 'batch_none', 'CamInterpreter', 'generate_gradcam', 'get_gcam_at',
           'show_gradcam_batch', 'GradCamInterpreter']

# Cell
from fastai2.vision.all import *
from .core import arch_summary, get_module, min_max_scale
from .transforms import to_grayscale
import copy
import gc

# Cell
def show_heatmap(cam,sz,ax=None,alpha=0.6,interpolation='bilinear',
                 cmap='magma'):
  show_image(min_max_scale(cam),ax=ax,
             extent=(1,sz,sz,1),alpha=alpha,
             interpolation=interpolation,cmap=cmap)

# Cell
def create_batch(dls:DataLoaders,fname,lbl_idx,size=None,method=None):
  """Create test_batch from filename and label index
  Refer `dls.vocab` to find validation index
  In case you want to Resize an image, use `size` and `method` parameters
  Default method of cropping is set to 'squish' cosidering the use-case
  """
  img = PILImage.create(fname)
  if size is not None:
    method = ifnone(method,'squish')
    resize = Resize(size,method=method)
    img = resize(img)
  xb, = first(dls.test_dl([img]))
  yb = dls.categorize(dls.vocab[lbl_idx])[None]
  return xb,yb

# Cell
class GuidedBackprop:
    "Produces gradients generated with guided back propagation from the given image"
    def __init__(self, model,act_cls:nn.Module=nn.ReLU):
        self.model = model.requires_grad_().eval()
        self.act_cls = act_cls
        self._fmaps = L()
        self._hooks = L()
        self._register_hooks()

    def hook(self,module,hook_fn,grad=False):
      if not grad:
        self._hooks += module.register_forward_hook(hook_fn)
      else:
        self._hooks += module.register_backward_hook(hook_fn)

    def _register_hooks(self):
        """Updates relu activation functions so that
        1- stores output in forward pass
        2- imputes zero for gradient values that are less than zero
        """
        def store_activations_hook(module,input,output):
            "Store forward pass outputs (Activaton Maps)"
            self._fmaps += output


        def clamp_gradients_hook(module,grad_in, grad_out):
            "If there is a negative gradient, change it to zero"
            # Get last forward output
            fmap = self._fmaps[-1]
            fmap[fmap > 0] = 1
            grad_out_new = fmap * F.relu(grad_in[0])
            del self._fmaps[-1]  # Remove last forward output
            return (grad_out_new,)

        # hook up ReLUs (activation layers)
        for name, module in self.model.named_modules():
            if isinstance(module, self.act_cls):
              self.hook(module,store_activations_hook)
              self.hook(module,clamp_gradients_hook,grad=True)

    def remove_hooks(self):
      for hook in self._hooks:
        hook.remove()
      gc.collect()

    def guided_backprop(self,xb,yb=None):
      xb = xb.clone() # To avoid modifying original tensors
      first_conv = flatten_model(self.model)[0]

      def hook_first(m,grad_in,grad_out): return grad_in[0]

      with Hook(first_conv,hook_first,is_forward=False) as reconstruction:
        xb.requires_grad_()
        if not xb.grad is None:
          xb.grad.zero_()
        y_preds = self.model(xb)
        self.model.zero_grad()
        if yb is None:
          y = y_preds.argmax().item()
        else: y = yb.item()
        y_preds[0,y].backward(retain_graph=True)
        gbprop = reconstruction.stored[0]
        self.remove_hooks()
        return gbprop

# Cell
from fastai2.vision.all import *
import gc
import copy
from .core import arch_summary, get_module, min_max_scale
from IPython.display import display
import kornia

# Cell
def generate_cam(model,xb,act_path:list=[0],wt_path:list=[1,-1],with_preds=False):
    """Show CAM for a given image
    `act_path`: list of indices to reach activation maps layer
    `wt_path`: list of indices to reach weight layer
    """
    if len(xb.shape)==3: xb= xb[None]

    act_layer = get_module(model,act_path)
    wt_layer = get_module(model,wt_path)
    with hook_output(act_layer) as hook:
      y_preds = model(xb)
      act = hook.stored
      cam = torch.einsum('ck,nkij->ncij', wt_layer.weight, act)

      #cleanup: to prevent memory-error
      del act,xb
      torch.cuda.empty_cache()

    if with_preds: return cam, y_preds
    return cam

# Cell
class CamImage:
  def __init__(self,x_dec,y_dec,pred_cls,cam:torch.Tensor):
    store_attr(self,'x_dec,y_dec,pred_cls,cam')

  def new(self,pred_cls,cam):
    x = copy.copy(self)
    x.pred_cls,x.cam = pred_cls,cam
    return x

  def show(self,ctx=None,merge=True,y_image=False,cmap='magma'):
    merge = merge and not y_image
    imsize = 5 if merge else 7
    if ctx is None:
      _,ctx = subplots(1,1 + int(not merge),figsize=(imsize,imsize))
    else:
      if not is_listy(ctx):
        # ctx is available, but only one, so merge
        merge=True
        ctx = [ctx]
      elif len(ctx)==2:
        # two ctx are available, so merge=False
        merge=False

    ax = self.x_dec.show(ctx=ctx[0])
    ax = self.y_dec.show(ctx=ax)
    is_correct = self.pred_cls==self.y_dec
    ax = show_title(self.pred_cls,ctx=ax,color='green' if is_correct else 'red')
    alpha = 0.6 if merge else 1.
    if not y_image:
      show_heatmap(self.cam,self.x_dec.shape[-1],ax=ctx[int(not merge)],alpha=alpha,cmap=cmap)
    else:
      show_image(min_max_scale(self.cam[0]),ax=ctx[int(not merge)],alpha=alpha,cmap=cmap)

# Cell
def get_at(batch_dec,cam_batch,y_preds,vocab,idx,for_cls=None)->CamImage:
  x,y = batch_dec[idx]
  cam_i = cam_batch[idx]
  del cam_batch # we don't need batch anymore, free-up memory

  if for_cls is not None:
    del y_preds
    class_id = for_cls
  else:
    class_id = y_preds[idx].argmax(-1).item()
  return CamImage(x,y,vocab[class_id],cam_i[class_id])

def show_at(model,dl,xb,yb,idx,merge=True,for_cls=None,gen=generate_cam):
  xib,yib = xb[idx][None],yb[idx][None]
  batch_dec = dl.decode_batch((xib,yib))
  cam_b,y_preds = gen(model,xib,with_preds=True)
  get_at(batch_dec,cam_b,y_preds,dl.vocab,idx=0,for_cls=for_cls).show(merge=merge)

# Cell
def show_cam_batch(xb,yb,dl,cam_batch,y_preds,max_n=9,merge=True,nrows=None, ncols=None, figsize=None):
  ctxs = get_grid(min(xb.shape[0],max_n),double=(not merge),add_vert=4,title='Target/Prediction')
  batch_dec = dl.decode_batch((xb,yb))
  getter = partial(get_at,batch_dec,cam_batch,y_preds,dl.vocab)
  if merge:
    for idx,ctx in enumerate(ctxs):
      cam_img = getter(idx)
      cam_img.show(ctx=ctx)
  else:
    for idx,ctx in enumerate(zip(ctxs[0::2],ctxs[1::2])):
      cam_img = getter(idx)
      cam_img.show(ctx=ctx)

# Cell
class BaseInterpreter:
  def __init__(self,model:nn.Module,valid_dl:DataLoader=None):
    self.model = copy.copy(model.eval())
    self.valid_dl = valid_dl
    self.valid_dl.shuffle=True
    self.vocab = valid_dl.vocab

  @classmethod
  def from_learner(cls,learn:Learner,ds_idx=1,dl=None):
    if dl is None: dl = learn.dls[ds_idx]
    return cls(learn.model,dl)

  @classmethod
  def is_cam_compatible(cls,model:nn.Module):
    """Check whether model is compatible for CAM
    The requirement is `GlobalAveragePooling` should be the penultimate layer
    """
    avg_idx=-1
    layers = flatten_model(model)
    for idx,layer in enumerate(layers):
      if isinstance(layer,(nn.AvgPool2d,nn.AdaptiveAvgPool2d)):
        avg_idx = len(layers) - idx - 1
    if not avg_idx in [1,2]: return False #AvgPool is not penultimate
    return True

  def label_list(self):
    "Show Class labels and indices (pretty-print `dls.vocab`)"
    df = pd.DataFrame(self.vocab,columns=['category'])
    return display(df.to_html())

# Cell
def batch_none(xb,yb):
  return xb is None and yb is None

class CamInterpreter(BaseInterpreter):

  @classmethod
  def from_learner(cls,learn:Learner,ds_idx=1,dl=None):
    assert cls.is_cam_compatible(learn.model),"ValueError: Model is not compatible"
    if dl is None: dl = learn.dls[ds_idx]
    return cls(learn.model,dl)

  @delegates(generate_cam)
  def generate(self,xb=None,yb=None,**kwargs):
    if batch_none(xb,yb):
      xb,yb = self.valid_dl.one_batch()
    return generate_cam(self.model,xb,**kwargs)

  @delegates(show_cam_batch,but=['xb,yb,cam_batch,y_preds'])
  def show_batch(self,xb=None,yb=None, **kwargs):
    if batch_none(xb,yb):
      xb,yb = self.valid_dl.one_batch()
    cam_batch,y_preds = self.generate(xb,with_preds=True)
    show_cam_batch(xb,yb,self.valid_dl,cam_batch,y_preds,**kwargs)

# Cell
def generate_gradcam(model,x,y=None,act_path:list=[0],with_preds=False):
  """Show Grad-CAM for a given image
    `xb,yb`: input batch
    `layer_idx`: list of indices to reach target layer
  """
  m = model.eval()
  hook_layer = get_module(m,act_path)
  if len(x.shape)==3: x = x.unsqueeze(0)
  with hook_output(hook_layer,grad=True) as hook_g:
    with hook_output(hook_layer) as hook:
      m.zero_grad()
      y_pred = m(x)
      if y is None:
        y = y_pred.argmax()
      y_pred[0,y].backward(retain_graph=True)
      acts = hook.stored[0]
    grads = hook_g.stored[0]
    grads = grads.mean((2,3))
    gcam = F.relu(torch.einsum('ab,bcd->acd',grads,acts))

    del grads,acts
    torch.cuda.empty_cache()

    if with_preds: return gcam,y_pred
    return gcam

# Cell
def get_gcam_at(batch_dec,cam_batch,y_preds,vocab,idx):
  x,y = batch_dec[idx]
  cam_i = cam_batch[idx]
  class_id = y_preds[idx].argmax(-1).item()
  return CamImage(x,y,vocab[class_id],cam_i)

# Cell
def show_gradcam_batch(xb,yb,dl,cam_batch,y_preds,max_n=9,cmap='magma',
                       merge=True,guided=False,nrows=None, ncols=None,
                       figsize=None):
  merge = merge and not guided
  ctxs = get_grid(min(xb.shape[0],max_n),double=(not merge),add_vert=4,title='Target/Prediction')
  batch_dec = dl.decode_batch((xb,yb))
  getter = partial(get_gcam_at,batch_dec,cam_batch,y_preds,dl.vocab)
  if merge:
    for idx,ctx in enumerate(ctxs):
      cam_img = getter(idx)
      cam_img.show(ctx=ctx,y_image=guided,cmap=cmap)
  else:
    for idx,ctx in enumerate(zip(ctxs[0::2],ctxs[1::2])):
      cam_img = getter(idx)
      cam_img.show(ctx=ctx,y_image=guided,cmap=cmap)

# Cell
class GradCamInterpreter(BaseInterpreter):

  def generate(self,xb=None,yb=None,act_path=[0],guided=False,with_preds=False):
    gcams = []
    y_preds = []

    if batch_none(xb,yb):
      xb,yb = self.valid_dl.one_batch()
      self.xb,self.yb = xb,yb # store for future reference

    for x,y in zip(xb,yb):
      gcam,preds = generate_gradcam(self.model,x,y,act_path=act_path,with_preds=True)

      if guided:
        gbviz = GuidedBackprop(self.model)
        gcam_up = F.interpolate(gcam[None],size=(224,224),mode='bilinear',align_corners=True)[0]
        gbprop = gbviz.guided_backprop(x[None],y[None])
        gcam = gcam_up * gbprop
        gcam.unsqueeze_(0)

      gcams.append(gcam[0])
      y_preds.append(preds[0])

    gcam_batch,y_preds = torch.stack(gcams),torch.stack(y_preds)

    del gcam,gcams
    if guided:
      del gcam_up,gbprop
    torch.cuda.empty_cache()

    if with_preds:
      return gcam_batch,y_preds
    else:
      del y_preds
      return gcam_batch


  @delegates(show_gradcam_batch,but=['xb,yb,cam_batch,y_preds,vocab'])
  def show_batch(self,xb=None,yb=None,act_path=[0],guided=False,**kwargs):
    if batch_none(xb,yb) and not hasattrs(self,('xb','yb')):
      xb,yb = self.valid_dl.one_batch()
      self.xb,self.yb = xb,yb # store for further reference

    cam_batch,y_preds = self.generate(xb,yb,act_path=act_path,guided=guided,with_preds=True)
    if guided:
      cam_batch = min_max_scale(cam_batch)
    show_gradcam_batch(self.xb,self.yb,self.valid_dl,cam_batch,y_preds,guided=guided,**kwargs)

  def show_at(self,idx,xb=None,yb=None,merge=True,cmap='magma',
              for_cls=None,act_path:list=[0],guided=False):
    merge = merge and not guided
    if batch_none(xb,yb) and not hasattrs(self,('xb','yb')):
      xb,yb = self.valid_dl.one_batch()
    else: xb,yb = self.xb,self.yb
    xib,yib = xb[idx][None],yb[idx][None]

    if for_cls is not None:
      yib = tensor(for_cls)[None]

    batch_dec = self.valid_dl.decode_batch((xib,yib))
    cam_b,y_preds = self.generate(xib,yib,guided=guided,with_preds=True)
    if guided:
        # cam_b = kornia.rgb_to_grayscale(cam_b)
        cam_b = min_max_scale(cam_b)
    get_gcam_at(batch_dec,cam_b,y_preds,self.vocab,idx=0).show(merge=merge,y_image=True,cmap=cmap)