# Contributing to Contextualized
Thank you for considering to contribute to Contextualized!


## Pull Requests
We welcome your pull requests (PRs).
For minor fixes (e.g., documentation improvements), feel free to submit a PR directly.
If you would like to implement a new feature or a bug, please make sure you (or someone else) has opened an appropriate [issue](https://github.com/cnellington/contextualized/issues) first; in your PR, please mention the issue it addresses.

### Creating a Pull Request
1. [Fork](https://github.com/cnellington/Contextualized/fork) this repository.
2. Install locally with `pip install -e .`.
3. Install extra developer dependencies with `pip install -r dev_requirements.txt`.
4. Make your code changes locally.
5. Automatically format your code and check for style issues by running `format_style.sh`. We are working on linting the entire repo, but please make sure your code is cleared by pylint.
6. Automatically update our documentation by running `update_docs.sh`.
7. (Optional) Include your name in alphabetical order in [ACKNOWLEDGEMENTS.md](https://github.com/cnellington/Contextualized/blob/main/ACKNOWLEDGEMENTS.md).
8. Issue a PR to merge your changes into the `main` branch.


## Issues
We use GitHub issues to track bugs and feature requests.
Before submitting an issue, please make sure:

1. You have read the README and your question is NOT addressed there.
2. You have done your best to ensure that your issue is NOT a duplicate of one of [the previous issues](https://github.com/cnellington/contextualized/issues).
3. Your issue is either a bug (unexpected/undesirable behavior) or a feature request.
If it is just a question, please ask it in the [Discussions](https://github.com/cnellington/contextualized/discussions) forum.

When submitting an issue, please make sure to use the appropriate template.


## License
By contributing to Contextualized, you agree that your contributions will be licensed
under the LICENSE file in the root directory of the source tree.
