"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationCode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3_assets = require("@aws-cdk/aws-s3-assets");
/**
 * (experimental) Code configuration providing the location to a Flink application JAR file.
 *
 * @experimental
 */
class ApplicationCode {
    /**
     * (experimental) Reference code from an S3 bucket.
     *
     * @param bucket - an s3 bucket.
     * @param fileKey - a key pointing to a Flink JAR file.
     * @param objectVersion - an optional version string for the provided fileKey.
     * @experimental
     */
    static fromBucket(bucket, fileKey, objectVersion) {
        return new BucketApplicationCode({
            bucket,
            fileKey,
            objectVersion,
        });
    }
    /**
     * (experimental) Reference code from a local directory containing a Flink JAR file.
     *
     * @param path - a local directory path.
     * @experimental
     * @parm options - standard s3 AssetOptions
     */
    static fromAsset(path, options) {
        return new AssetApplicationCode(path, options);
    }
}
exports.ApplicationCode = ApplicationCode;
_a = JSII_RTTI_SYMBOL_1;
ApplicationCode[_a] = { fqn: "@aws-cdk/aws-kinesisanalytics-flink.ApplicationCode", version: "1.144.0" };
class BucketApplicationCode extends ApplicationCode {
    constructor(props) {
        super();
        this.bucket = props.bucket;
        this.fileKey = props.fileKey;
        this.objectVersion = props.objectVersion;
    }
    bind(_scope) {
        return {
            applicationCodeConfigurationProperty: {
                applicationCodeConfiguration: {
                    codeContent: {
                        s3ContentLocation: {
                            bucketArn: this.bucket.bucketArn,
                            fileKey: this.fileKey,
                            objectVersion: this.objectVersion,
                        },
                    },
                    codeContentType: 'ZIPFILE',
                },
            },
            bucket: this.bucket,
        };
    }
}
class AssetApplicationCode extends ApplicationCode {
    constructor(path, options) {
        super();
        this.path = path;
        this.options = options;
    }
    bind(scope) {
        this._asset = new s3_assets.Asset(scope, 'Code', {
            path: this.path,
            ...this.options,
        });
        if (!this._asset.isZipArchive) {
            throw new Error(`Asset must be a .zip file or a directory (${this.path})`);
        }
        return {
            applicationCodeConfigurationProperty: {
                applicationCodeConfiguration: {
                    codeContent: {
                        s3ContentLocation: {
                            bucketArn: this._asset.bucket.bucketArn,
                            fileKey: this._asset.s3ObjectKey,
                        },
                    },
                    codeContentType: 'ZIPFILE',
                },
            },
            bucket: this._asset.bucket,
        };
    }
    get asset() {
        return this._asset;
    }
    get bucket() {
        var _b;
        return (_b = this._asset) === null || _b === void 0 ? void 0 : _b.bucket;
    }
}
//# sourceMappingURL=data:application/json;base64,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