# arlas-permissions-api-python
permissions REST services

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 16.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [http://www.gisaia.com/](http://www.gisaia.com/)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import arlas_permissions_api_python 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import arlas_permissions_api_python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import arlas_permissions_api_python
from arlas_permissions_api_python.rest import ApiException
from pprint import pprint
# create an instance of the API class
api_instance = arlas_permissions_api_python.AuthorizeApi()
filter = 'filter_example' # str | A regex to apply to permissions uris in order to filter the returned list.
pretty = false # bool | Pretty print (optional) (default to false)

try:
    # Returns a list of permissions for the current context/user
    api_response = api_instance.get(filter, pretty=pretty)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthorizeApi->get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/arlas_permissions_server*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthorizeApi* | [**get**](docs/AuthorizeApi.md#get) | **GET** /authorize/resources | Returns a list of permissions for the current context/user


## Documentation For Models

 - [Error](docs/Error.md)
 - [Resource](docs/Resource.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

contact@gisaia.com

