# roboweb-extension

![Github Actions Status](https://github.com/github_username/roboweb-extension/workflows/Build/badge.svg)

Roboweb extension

## Requirements

* JupyterLab >= 3.1

## Install

```bash
pip install roboweb-extension
```

## Contributing

### Development install

Note: You will need NodeJS to build the extension package.

The `jlpm` command is JupyterLab's pinned version of
[yarn](https://yarnpkg.com/) that is installed with JupyterLab. You may use
`yarn` or `npm` in lieu of `jlpm` below.

```bash
# Clone the repo to your local environment
# Change directory to the roboweb-extension directory
# Install package in development mode
pip install -e .
# Link your development version of the extension with JupyterLab
jupyter labextension develop . --overwrite
# Rebuild extension Typescript source after making changes
jlpm run build
```

You can watch the source directory and run JupyterLab at the same time in different terminals to watch for changes in the extension's source and automatically rebuild the extension.

```bash
# Watch the source directory in one terminal, automatically rebuilding when needed
jlpm run watch
# Run JupyterLab in another terminal
jupyter lab
```

With the watch command running, every saved change will immediately be built locally and available in your running JupyterLab. Refresh JupyterLab to load the change in your browser (you may need to wait several seconds for the extension to be rebuilt).

By default, the `jlpm run build` command generates the source maps for this extension to make it easier to debug using the browser dev tools. To also generate source maps for the JupyterLab core extensions, you can run the following command:

```bash
jupyter lab build --minimize=False
```

### Uninstall

```bash
pip uninstall roboweb-extension
```

## Updating the version

To update the version, install tbump and use it to bump the version.
By default it will also create a tag.

```bash
pip install tbump
tbump <new-version>
```

## How it Works

The flutter application is compiled into a web application. This web application
is then embeded into JupyterLab using 
[Flutter's Embedding](https://github.com/flutter/samples/blob/main/experimental/element_embedding_demo/README.md) 
feature. 

[Flutter Embedding](https://github.com/flutter/samples/blob/main/experimental/element_embedding_demo/README.md)
lets flutter take over a particular div element on the page rather than the whole page.

There are two extensions

* `roboweb-server`: JupyterLab extension embedding the Flutter app as a side nav item
* `roboweb-server-extension`: Jupyter Server extension serving the Flutter app's .js and static assets

The former creates the sidebar item and as part of that adds a `div` element in which the flutter
application can render itself. The main code is inside [./roboweb-extension/lib/index.js](./roboweb-extension/lib/index.js).

The `roboweb-server-extension` serves the static assets for the flutter application. The
file [roboweb-server-extension/roboweb_server_extension.py](roboweb-server-extension/roboweb_server_extension.py)
adds a handler to the JupyterLab tornado server to serve the static assets.

Unfortunately, the asset paths that flutter would normally use don't match the asset paths as used by
the JupyterLabServer so we need to hack the javascript that flutter is compiled to to configure the correct
paths. This is handled by [build.py](build.py) which modifies the files post build.
