"""
Django settings for django_site_warnings_server project.

Generated by 'django-admin startproject' using Django 2.2.19.

For more information on this file, see
https://docs.djangoproject.com/en/2.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.2/ref/settings/
"""

import os

DJANGO_SITE_WARNINGS_REDIS_PASSWORD = os.environ.get("DJANGO_SITE_WARNINGS_REDIS_PASSWORD", "")
DJANGO_SITE_WARNINGS_REDIS_HOST = os.environ.get("DJANGO_SITE_WARNINGS_REDIS_HOST", "127.0.0.1")
DJANGO_SITE_WARNINGS_REDIS_PORT = os.environ.get("DJANGO_SITE_WARNINGS_REDIS_PORT", 6379)
DJANGO_SITE_WARNINGS_REDIS_DB = os.environ.get("DJANGO_SITE_WARNINGS_REDIS_DB", 0)

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.getcwd()


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'DiIHYfMZVkBc9O24NDw8QyZN4bBIqJUsWgHGIaUz5dkta1rUIQYaX8pDb6zc2kMR'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = [
    'django_site_warnings',
    'django_admin_global_sidebar',
    'django_horizontal_list_filter',
    'django_server_controller',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]

from django_app_requires import add_requires
INSTALLED_APPS = add_requires(INSTALLED_APPS)

DJANGO_ADMIN_GLOBAL_SIDEBAR_MENUS = "django_site_warnings.global_sidebar.get_default_global_sidebar"

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'django_site_warnings_server.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'django_site_warnings_server.wsgi.application'


# Database
# https://docs.djangoproject.com/en/2.2/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}

CACHES = {
    "default": {
        "BACKEND": "django_redis.cache.RedisCache",
        "LOCATION": f"redis://:{DJANGO_SITE_WARNINGS_REDIS_PASSWORD}@{DJANGO_SITE_WARNINGS_REDIS_HOST}:{DJANGO_SITE_WARNINGS_REDIS_PORT}/{DJANGO_SITE_WARNINGS_REDIS_DB}?decode_responses=True",
        
    }
}


# Password validation
# https://docs.djangoproject.com/en/2.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/2.2/topics/i18n/

LANGUAGE_CODE = 'zh-hans'

TIME_ZONE = 'Asia/Shanghai'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.2/howto/static-files/

STATIC_URL = '/static/'
DEFAULT_AUTO_FIELD = "django.db.models.AutoField"

WSGI_SERVER_ENGINE = "gunicorn"

try:
    from django_site_warnings_server_local_settings import *
except ImportError:
    pass
