# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tegracli']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0',
 'Telethon>=1.24.0,<2.0.0',
 'click>=8.1.3,<9.0.0',
 'loguru>=0.6.0,<0.7.0',
 'pandas>=1.4.3,<2.0.0',
 'ujson>=5.4.0,<6.0.0']

entry_points = \
{'console_scripts': ['tegracli = tegracli.main:cli']}

setup_kwargs = {
    'name': 'tegracli',
    'version': '0.1.2',
    'description': 'A research-focused Telegram CLI application',
    'long_description': "# tegracli\n\n![The TEGRACLI logo](https://github.com/Leibniz-HBI/tegracli/blob/trunk/tegracli.png?raw=true)\n\nA convenience wrapper around Telethon and the Telegram Client API for research purposes.\n\n# Installation Instructions\n\n`tegracli` uses Poetry and python >= 3.9 and < 4.0 for building and installing.\n\nTo install using pipx, run the following command `pipx install tegracli`.\n\n## How to get API keys\n\nIf you don't have API keys for Telegram, head over to [my.telegram.org](https://my.telegram.org).\nClick on [API development tools](https://my.telegram.org/apps), fill the form to create yourself an app and pluck the keys into `tegracli.conf.yml`. The session name can be arbitrary.\n\n```yaml\napi_id: 1234567\napi_hash : some12321hashthatmustbehere123\nsession_name: somesessionyo\n```\n\nThis template file is provided with the repository.\n\n# Usage\n\n`tegracli` is a terminal application to access the Telegram API for research purposes.\nIn order to retrieve messages the configuration-file from the section before must be present in the directory you start `tegracli`.\nThe following commands are available:\n\n## GET\n\nTo _get_ messages from a number of channels, use this command.\n\n```\nUsage: tegracli get [OPTIONS] [CHANNELS]...\n\n  Get messages for the specified channels by either ID or username.\n\nOptions:\n  -l, --limit INTEGER           Number of messages to retrieve.\n  -O, --offset_date [%Y-%m-%d]  Offset retrieval to specific date in YYYY-MM-\n                                DD format.\n  -o, --offset_id INTEGER       Offset retrieval to a specific post number.\n  -m, --min_id INTEGER          Minimal post number.\n  -M, --max_id INTEGER          Maximal post number\n  -a, --add_offset INTEGER      Add an offset to the post numbers to be\n                                retrieved.\n  -f, --from_user TEXT          Only messages from this user.\n  --reverse / --forward         Should post numbers count upward or downward.\n                                Defaults to forward.\n  -r, --reply_to TEXT           Only messages replied to specific post id.\n  --help                        Show this message and exit.\n```\n| **parameter**       | **description**                                                                                                              |\n| ------------------- | ---------------------------------------------------------------------------------------------------------------------------- |\n| **channels**        | a list of of either telegram usernames, channel or group URLs or user IDs.                                                   |\n| **limit**           | number of messages to retrieve, positive integer. If set to `-1` , retrieves all messages in the channel. defaults to `-1`.  |\n| **offset_date**     | specify start point of retrieval by date, retrieval direction is controlled by `reverse/forward`. Format must be YYYY-MM-DD. |\n| **offset_id**       | specify start point of retrieval by post number, retrieval direction is controlled by `reverse/forward`.                     |\n| **min_id**          | sets the minimum post number                                                                                                 |\n| **max_id**          | sets the maximum post number                                                                                                 |\n| **add_offset**      | add a offset to the post numbers to be retrieved                                                                             |\n| **from_user**       | limit messages to posts *from* a specific user                                                                               |\n| **reply_to**        | limit messages to replies *to* a specific user                                                                               |\n| **reverse/forward** | flag to indicate whether messages should be retrieved in chronological or reverse chronological order.                       |\n\n### Basic Examples\n\nTo retrieve the last fifty messages from a Telegram channel:\n\n```\ntegracli get --limit 50 corona_infokanal_bmg\n```\n\nTo retrieve the entire history starting with post #1 of a channel, set `limit` to `-1`.\n\n```\ntegracli get --reverse --limit -1 corona_infokanal_bmg\n```\nTo retrieve messages sent after Januar, 1st 2022:\n\n```\ntegracli get --offset_data 2022-01-01 corona_infokanal_bmg\n```\n\nTo retrieve message sent before Januar, 1st 2022:\n\n```\ntegracli get --reverse --offset_data 2022-01-01 corona_infokanal_bmg\n```\n## SEARCH\n\nTo _search_ messages of your chats and groups and channels you are subscribed to, use this command.\n\n```\nUsage: tegracli search [OPTIONS] [QUERIES]...\n\n  This function searches Telegram content that is available to your account for the specified search term(s).\n\nOptions:\n  --help  Show this message and exit.\n```\n\n## GROUP INIT and GROUP RUN\n\nIn order to support updatable  and long running collections `tegracli` sports an *account group* feature which retrieves\nthe history of a given set of accounts and is able to retrieve updates on each of these accounts.\n\nGroups are initialized by calling `teracli group init`, where accounts to track are stated by either stating them as arguments\nor by reading in a file.\n\n### Account Group File Format\n\nAccount files are expected to follow these requirements:\n\n- UTF8 text document,\n- per line one accout, given as either username, channel-URL or ID,\n- there shall be no header and  no additional columns\n\n```\nUsage: tegracli group init [OPTIONS] NAME [ACCOUNTS]...\n\n  initialize a new account group\n\nOptions:\n  -f, --read_file PATH         read an account list from a file, one\n                               handle/id/url per line.\n  -s, --start_date [%Y-%m-%d]  Start date for the collection. Must be in YYYY-\n                               MM-DD format.\n  -l, --limit INTEGER          number of posts fo retrieve in one run\n  --help                       Show this message and exit.\n```\n\nA group is essentially a directory in your tegracli project folder which holdes\nan group configuration file, a `profiles.jsonl` file which will collect all user objects returned\nby Telegram (these will be recycled to save API requests), as well as the jsonl-files containing the messages.\nThe messages-files are structured in a way that one file holds the messages of one account and is named by the\naccount's ID.\n\nAn exemplary project could look this:\n\n```\ntegracli-project/\n |- tegracli.conf.yml\n |- mysession.session\n |- my_group/\n    |- tegracli_group.conf.yml\n    |- profiles.jsonl\n    |- 10000001.jsonl\n    |- 10000002.jsonl\n```\nTo run the project command your terminal to `tegracli group run my_group` to collect the latest post of the accounts you want to track.\n\n```\nUsage: tegracli group run [OPTIONS] [GROUPS]...\n\n  load a group configuration and run the groups operations\n```\n\n## Result File Format\n\nMessages are stored in `jsonl`-files per channel or query. For channels filename is the channel's or user's id, for searches the query.\n**BEWARE:** how directories and files are layed out is subject to active development and prone to changes in the near future.\n\n# Developer Installation\n\n1. Install [poetry](https://python-poetry.org/docs/#installation),\n2. Clone repository and unzip, if necessary,\n3. In the directory run `poetry install`,\n4. Run `poetry shell` to start the development virtualenv,\n6. Run `pytest` to run tests, run `pytest --run_api` too include tests against the Telegram API (**these do require a valid configuration**), coverage report can be found under `tests/coverage`.\n",
    'author': 'Philipp Kessling',
    'author_email': 'p.kessling@leibniz-hbi.de',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://pypi.org/project/tegracli/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
