# Generated by Django 2.2.15 on 2020-09-21 10:12

from django.db import migrations, models

import gzip


def gzip_repodata(apps, schema_editor):
    """
    Compress repodata and store different types of it in a separate field.

    Also remove uncompressed repodata.
    """

    def gzip_pkg_repodata(pkg):
        pkg.primary_template_gz = gzip.zlib.compress(pkg.repodata.get('primary').encode())
        pkg.other_template_gz = gzip.zlib.compress(pkg.repodata.get('other').encode())
        pkg.filelists_template_gz = gzip.zlib.compress(pkg.repodata.get('filelists').encode())
        pkg.repodata = ''
        return pkg
    
    Pulp2Rpm = apps.get_model('pulp_2to3_migration', 'Pulp2Rpm')
    Pulp2Srpm = apps.get_model('pulp_2to3_migration', 'Pulp2Srpm')

    batch_size = 500
    fields_to_update = ('repodata', 'primary_template_gz', 'other_template_gz',
                        'filelists_template_gz')

    for model in (Pulp2Rpm, Pulp2Srpm):
        batch_to_save = []
        for pkg in model.objects.filter().iterator():
            batch_to_save.append(gzip_pkg_repodata(pkg))
            if len(batch_to_save) == batch_size:
                model.objects.bulk_update(batch_to_save, fields=fields_to_update)
                batch_to_save = []

        if batch_to_save:
            model.objects.bulk_update(batch_to_save, fields=fields_to_update)


class Migration(migrations.Migration):

    dependencies = [
        ('pulp_2to3_migration', '0013_fix_file_remote_migration'),
    ]

    operations = [
        migrations.AddField(
            model_name='pulp2rpm',
            name='filelists_template_gz',
            field=models.BinaryField(null=True),
        ),
        migrations.AddField(
            model_name='pulp2rpm',
            name='other_template_gz',
            field=models.BinaryField(null=True),
        ),
        migrations.AddField(
            model_name='pulp2rpm',
            name='primary_template_gz',
            field=models.BinaryField(null=True),
        ),
        migrations.AddField(
            model_name='pulp2srpm',
            name='filelists_template_gz',
            field=models.BinaryField(null=True),
        ),
        migrations.AddField(
            model_name='pulp2srpm',
            name='other_template_gz',
            field=models.BinaryField(null=True),
        ),
        migrations.AddField(
            model_name='pulp2srpm',
            name='primary_template_gz',
            field=models.BinaryField(null=True),
        ),

        migrations.RunPython(gzip_repodata),

        # Those fields can be removed only after data migration happened
        migrations.RemoveField(
            model_name='pulp2rpm',
            name='repodata',
        ),
        migrations.RemoveField(
            model_name='pulp2srpm',
            name='repodata',
        ),
    ]
