"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaInvocation = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
class LambdaInvocation {
    constructor(scope, fn) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        this.partition = stack.partition;
        this.region = stack.region;
        this.functionArn = fn.functionArn;
        this.uri = this.resolveUri(this.partition, this.region, this.functionArn);
    }
    resolveArnResource(partition, region) {
        return [
            'arn',
            partition,
            LambdaInvocation.service,
            region,
            LambdaInvocation.resourceType,
        ].join(':');
    }
    resolveArnResourcePath(functionArn) {
        return [
            'path',
            LambdaInvocation.apiVersion,
            'functions',
            functionArn,
            'invocations',
        ].join('/');
    }
    resolveUri(partition, region, functionArn) {
        const arnResource = this.resolveArnResource(partition, region);
        const arnPath = this.resolveArnResourcePath(functionArn);
        return `${arnResource}:${arnPath}`;
    }
}
exports.LambdaInvocation = LambdaInvocation;
/** Lambda API version. */
LambdaInvocation.apiVersion = '2015-03-31';
LambdaInvocation.service = 'apigateway';
LambdaInvocation.resourceType = 'lambda';
//# sourceMappingURL=data:application/json;base64,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