import * as apigateway from 'aws-cdk-lib/aws-apigateway';
import { ServicePrincipal } from 'aws-cdk-lib/aws-iam';
import { IFunction } from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
import { Integration, ValidatorConfig } from './base';
export interface LambdaIntegrationOptions extends apigateway.LambdaIntegrationOptions, ValidatorConfig {
}
/** Defines an AWS Lambda integration. */
export declare class LambdaIntegration extends Integration {
    /**
     * Selects the Lambda integration type.
     *
     * @default
     * 'AWS_PROXY'
     */
    private static selectIntegrationType;
    readonly fn: IFunction;
    /**
     * Defines an AWS Lambda integration.
     *
     * @example
     * '/message': {
     *    'POST': new openapix.LambdaIntegration(this, fn),
     * },
     */
    constructor(scope: Construct, fn: IFunction, props?: LambdaIntegrationOptions);
    /** Allow Lambda invoke action to be performed by given identity. */
    grantFunctionInvoke(scope: Construct, id: string, principal: ServicePrincipal): void;
}
