import * as apigateway from 'aws-cdk-lib/aws-apigateway';
import { Construct } from 'constructs';
import { Integration, ValidatorConfig } from './base';
export interface HttpIntegrationProps extends apigateway.HttpIntegrationProps, ValidatorConfig {
}
/** Defines a HTTP(S) integration. */
export declare class HttpIntegration extends Integration {
    /**
     * Selects the integration HTTP method.
     *
     * @default
     * 'GET'
     */
    private static selectIntegrationHttpMethod;
    /** Selects the correct integration type configuration. */
    private static selectIntegrationType;
    /**
     * Defines a HTTP(S) integration.
     *
     * @example
     * '/ext': {
     *   'ANY': new openapix.HttpIntegration(this, "https://example.com"),
     * },
     */
    constructor(_: Construct, url: string, props?: HttpIntegrationProps);
}
