"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const base_1 = require("./base");
/** Defines direct AWS service integration. */
class AwsIntegration extends base_1.Integration {
    /**
     * Defines direct AWS service integration.
     *
     * @example
     * '/item': {
     *   'GET': new openapix.AwsIntegration(this, {
     *     service: 'dynamodb',
     *     action: 'GetItem',
     *     options: {
     *       credentialsRole: role,
     *       requestTemplates: {
     *         'application/json': JSON.stringify({
     *           "TableName": table.tableName,
     *           "Key": {
     *             'PK': {
     *               "S": "$input.params('item')"
     *             }
     *           }
     *         }),
     *       },
     *     },
     *   }),
     * },
     */
    constructor(scope, props) {
        const integration = {
            type: aws_apigateway_1.IntegrationType.AWS,
            uri: AwsIntegration.resolveUri(scope, props),
            integrationHttpMethod: props.integrationHttpMethod || 'POST',
            options: props.options,
        };
        const config = {
            type: base_1.InternalIntegrationType.AWS,
            validator: props.validator,
        };
        super(integration, config);
    }
    /** Resolves the AWS service integration URI. */
    static resolveUri(scope, props) {
        const region = props.region || aws_cdk_lib_1.Stack.of(scope).region;
        return `arn:aws:apigateway:${region}:${props.service}:action/${props.action}`;
    }
}
exports.AwsIntegration = AwsIntegration;
_a = JSII_RTTI_SYMBOL_1;
AwsIntegration[_a] = { fqn: "@alma-cdk/openapix.AwsIntegration", version: "0.0.45" };
//# sourceMappingURL=data:application/json;base64,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