"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CorsHeaders = exports.CorsMethods = exports.CorsOrigins = void 0;
const add_1 = require("../errors/add");
class CorsSettingValue {
    static from(scope, ...values) {
        if (values.length < 1) {
            add_1.addError(scope, CorsSettingValue.errorMessage);
            return '';
        }
        return values.join(',');
    }
}
CorsSettingValue.ANY = '*';
class CorsOrigins extends CorsSettingValue {
}
exports.CorsOrigins = CorsOrigins;
CorsOrigins.errorMessage = 'CorsOrigins.fromList() call values must contain at least 1 origin';
class CorsMethods extends CorsSettingValue {
}
exports.CorsMethods = CorsMethods;
CorsMethods.errorMessage = 'CorsMethods.fromList() call values must contain at least 1 method';
// https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers
class CorsHeaders extends CorsSettingValue {
}
exports.CorsHeaders = CorsHeaders;
CorsHeaders.errorMessage = 'CorsHeaders.fromList() call values must contain at least 1 header';
//# sourceMappingURL=data:application/json;base64,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